# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LogCaptureUserConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LogCaptureUserConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_started': 'datetime',
            'date_expired': 'datetime',
            'capture_method': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date_started': 'dateStarted',
            'date_expired': 'dateExpired',
            'capture_method': 'captureMethod',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._date_started = None
        self._date_expired = None
        self._capture_method = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LogCaptureUserConfiguration.
        The globally unique identifier for the object.

        :return: The id of this LogCaptureUserConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LogCaptureUserConfiguration.
        The globally unique identifier for the object.

        :param id: The id of this LogCaptureUserConfiguration.
        :type: str
        """
        

        self._id = id

    @property
    def date_started(self) -> datetime:
        """
        Gets the date_started of this LogCaptureUserConfiguration.
        Indicates when log capture was enabled for the user. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_started of this LogCaptureUserConfiguration.
        :rtype: datetime
        """
        return self._date_started

    @date_started.setter
    def date_started(self, date_started: datetime) -> None:
        """
        Sets the date_started of this LogCaptureUserConfiguration.
        Indicates when log capture was enabled for the user. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_started: The date_started of this LogCaptureUserConfiguration.
        :type: datetime
        """
        

        self._date_started = date_started

    @property
    def date_expired(self) -> datetime:
        """
        Gets the date_expired of this LogCaptureUserConfiguration.
        Indicates when log capture will be turned off for the user. (Must be within 24 hours). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_expired of this LogCaptureUserConfiguration.
        :rtype: datetime
        """
        return self._date_expired

    @date_expired.setter
    def date_expired(self, date_expired: datetime) -> None:
        """
        Sets the date_expired of this LogCaptureUserConfiguration.
        Indicates when log capture will be turned off for the user. (Must be within 24 hours). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_expired: The date_expired of this LogCaptureUserConfiguration.
        :type: datetime
        """
        

        self._date_expired = date_expired

    @property
    def capture_method(self) -> str:
        """
        Gets the capture_method of this LogCaptureUserConfiguration.
        Indicates the method by which the logs were captured.

        :return: The capture_method of this LogCaptureUserConfiguration.
        :rtype: str
        """
        return self._capture_method

    @capture_method.setter
    def capture_method(self, capture_method: str) -> None:
        """
        Sets the capture_method of this LogCaptureUserConfiguration.
        Indicates the method by which the logs were captured.

        :param capture_method: The capture_method of this LogCaptureUserConfiguration.
        :type: str
        """
        if isinstance(capture_method, int):
            capture_method = str(capture_method)
        allowed_values = ["OnDemand", "Scheduled"]
        if capture_method.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for capture_method -> " + capture_method)
            self._capture_method = "outdated_sdk_version"
        else:
            self._capture_method = capture_method

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LogCaptureUserConfiguration.
        The URI for this object

        :return: The self_uri of this LogCaptureUserConfiguration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LogCaptureUserConfiguration.
        The URI for this object

        :param self_uri: The self_uri of this LogCaptureUserConfiguration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

