# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ForecastMetadata
    from . import PlanningGroupRequirementOutput

class LongTermRequirements(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LongTermRequirements - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'forecast_metadata': 'ForecastMetadata',
            'date_generation_started': 'datetime',
            'requirement_results': 'list[PlanningGroupRequirementOutput]'
        }

        self.attribute_map = {
            'forecast_metadata': 'forecastMetadata',
            'date_generation_started': 'dateGenerationStarted',
            'requirement_results': 'requirementResults'
        }

        self._forecast_metadata = None
        self._date_generation_started = None
        self._requirement_results = None

    @property
    def forecast_metadata(self) -> 'ForecastMetadata':
        """
        Gets the forecast_metadata of this LongTermRequirements.
        Forecast metadata

        :return: The forecast_metadata of this LongTermRequirements.
        :rtype: ForecastMetadata
        """
        return self._forecast_metadata

    @forecast_metadata.setter
    def forecast_metadata(self, forecast_metadata: 'ForecastMetadata') -> None:
        """
        Sets the forecast_metadata of this LongTermRequirements.
        Forecast metadata

        :param forecast_metadata: The forecast_metadata of this LongTermRequirements.
        :type: ForecastMetadata
        """
        

        self._forecast_metadata = forecast_metadata

    @property
    def date_generation_started(self) -> datetime:
        """
        Gets the date_generation_started of this LongTermRequirements.
        Date the generation of the requirements started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_generation_started of this LongTermRequirements.
        :rtype: datetime
        """
        return self._date_generation_started

    @date_generation_started.setter
    def date_generation_started(self, date_generation_started: datetime) -> None:
        """
        Sets the date_generation_started of this LongTermRequirements.
        Date the generation of the requirements started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_generation_started: The date_generation_started of this LongTermRequirements.
        :type: datetime
        """
        

        self._date_generation_started = date_generation_started

    @property
    def requirement_results(self) -> List['PlanningGroupRequirementOutput']:
        """
        Gets the requirement_results of this LongTermRequirements.
        List of planning group outputs

        :return: The requirement_results of this LongTermRequirements.
        :rtype: list[PlanningGroupRequirementOutput]
        """
        return self._requirement_results

    @requirement_results.setter
    def requirement_results(self, requirement_results: List['PlanningGroupRequirementOutput']) -> None:
        """
        Sets the requirement_results of this LongTermRequirements.
        List of planning group outputs

        :param requirement_results: The requirement_results of this LongTermRequirements.
        :type: list[PlanningGroupRequirementOutput]
        """
        

        self._requirement_results = requirement_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

