# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LongTermRequirements

class LongTermRequirementsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LongTermRequirementsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status': 'str',
            'error_code': 'str',
            'long_term_requirements': 'LongTermRequirements',
            'download_url': 'str'
        }

        self.attribute_map = {
            'status': 'status',
            'error_code': 'errorCode',
            'long_term_requirements': 'longTermRequirements',
            'download_url': 'downloadUrl'
        }

        self._status = None
        self._error_code = None
        self._long_term_requirements = None
        self._download_url = None

    @property
    def status(self) -> str:
        """
        Gets the status of this LongTermRequirementsResponse.
        Status of the long term forecast

        :return: The status of this LongTermRequirementsResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this LongTermRequirementsResponse.
        Status of the long term forecast

        :param status: The status of this LongTermRequirementsResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Processing", "Complete", "Canceled", "Error"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this LongTermRequirementsResponse.
        Error code when status is Failed

        :return: The error_code of this LongTermRequirementsResponse.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this LongTermRequirementsResponse.
        Error code when status is Failed

        :param error_code: The error_code of this LongTermRequirementsResponse.
        :type: str
        """
        if isinstance(error_code, int):
            error_code = str(error_code)
        allowed_values = ["TimedOut", "NoData", "ClientDataInvalid", "ConfigurationInvalid", "RequirementsFailed"]
        if error_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for error_code -> " + error_code)
            self._error_code = "outdated_sdk_version"
        else:
            self._error_code = error_code

    @property
    def long_term_requirements(self) -> 'LongTermRequirements':
        """
        Gets the long_term_requirements of this LongTermRequirementsResponse.
        For schema documentation only, always null, schema for staffing forecast result at downloadUrl

        :return: The long_term_requirements of this LongTermRequirementsResponse.
        :rtype: LongTermRequirements
        """
        return self._long_term_requirements

    @long_term_requirements.setter
    def long_term_requirements(self, long_term_requirements: 'LongTermRequirements') -> None:
        """
        Sets the long_term_requirements of this LongTermRequirementsResponse.
        For schema documentation only, always null, schema for staffing forecast result at downloadUrl

        :param long_term_requirements: The long_term_requirements of this LongTermRequirementsResponse.
        :type: LongTermRequirements
        """
        

        self._long_term_requirements = long_term_requirements

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this LongTermRequirementsResponse.
        Download URL for the staffing forecast result

        :return: The download_url of this LongTermRequirementsResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this LongTermRequirementsResponse.
        Download URL for the staffing forecast result

        :param download_url: The download_url of this LongTermRequirementsResponse.
        :type: str
        """
        

        self._download_url = download_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

