# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LongTermRequirementsServiceGoal(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LongTermRequirementsServiceGoal - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'use_asa_target': 'bool',
            'target_asa_sec': 'float',
            'use_service_level_target': 'bool',
            'service_level_objective_seconds': 'float',
            'service_level_goal_percent': 'float',
            'use_abandon_rate_goal': 'bool',
            'abandon_rate_goal_percent': 'float'
        }

        self.attribute_map = {
            'use_asa_target': 'useAsaTarget',
            'target_asa_sec': 'targetAsaSec',
            'use_service_level_target': 'useServiceLevelTarget',
            'service_level_objective_seconds': 'serviceLevelObjectiveSeconds',
            'service_level_goal_percent': 'serviceLevelGoalPercent',
            'use_abandon_rate_goal': 'useAbandonRateGoal',
            'abandon_rate_goal_percent': 'abandonRateGoalPercent'
        }

        self._use_asa_target = None
        self._target_asa_sec = None
        self._use_service_level_target = None
        self._service_level_objective_seconds = None
        self._service_level_goal_percent = None
        self._use_abandon_rate_goal = None
        self._abandon_rate_goal_percent = None

    @property
    def use_asa_target(self) -> bool:
        """
        Gets the use_asa_target of this LongTermRequirementsServiceGoal.
        Toggle for target average speed of answer from service goals

        :return: The use_asa_target of this LongTermRequirementsServiceGoal.
        :rtype: bool
        """
        return self._use_asa_target

    @use_asa_target.setter
    def use_asa_target(self, use_asa_target: bool) -> None:
        """
        Sets the use_asa_target of this LongTermRequirementsServiceGoal.
        Toggle for target average speed of answer from service goals

        :param use_asa_target: The use_asa_target of this LongTermRequirementsServiceGoal.
        :type: bool
        """
        

        self._use_asa_target = use_asa_target

    @property
    def target_asa_sec(self) -> float:
        """
        Gets the target_asa_sec of this LongTermRequirementsServiceGoal.
        Value of target average speed of answer from service goals

        :return: The target_asa_sec of this LongTermRequirementsServiceGoal.
        :rtype: float
        """
        return self._target_asa_sec

    @target_asa_sec.setter
    def target_asa_sec(self, target_asa_sec: float) -> None:
        """
        Sets the target_asa_sec of this LongTermRequirementsServiceGoal.
        Value of target average speed of answer from service goals

        :param target_asa_sec: The target_asa_sec of this LongTermRequirementsServiceGoal.
        :type: float
        """
        

        self._target_asa_sec = target_asa_sec

    @property
    def use_service_level_target(self) -> bool:
        """
        Gets the use_service_level_target of this LongTermRequirementsServiceGoal.
        Toggle for service level objective from service goals

        :return: The use_service_level_target of this LongTermRequirementsServiceGoal.
        :rtype: bool
        """
        return self._use_service_level_target

    @use_service_level_target.setter
    def use_service_level_target(self, use_service_level_target: bool) -> None:
        """
        Sets the use_service_level_target of this LongTermRequirementsServiceGoal.
        Toggle for service level objective from service goals

        :param use_service_level_target: The use_service_level_target of this LongTermRequirementsServiceGoal.
        :type: bool
        """
        

        self._use_service_level_target = use_service_level_target

    @property
    def service_level_objective_seconds(self) -> float:
        """
        Gets the service_level_objective_seconds of this LongTermRequirementsServiceGoal.
        Value of service level objective seconds from service goals

        :return: The service_level_objective_seconds of this LongTermRequirementsServiceGoal.
        :rtype: float
        """
        return self._service_level_objective_seconds

    @service_level_objective_seconds.setter
    def service_level_objective_seconds(self, service_level_objective_seconds: float) -> None:
        """
        Sets the service_level_objective_seconds of this LongTermRequirementsServiceGoal.
        Value of service level objective seconds from service goals

        :param service_level_objective_seconds: The service_level_objective_seconds of this LongTermRequirementsServiceGoal.
        :type: float
        """
        

        self._service_level_objective_seconds = service_level_objective_seconds

    @property
    def service_level_goal_percent(self) -> float:
        """
        Gets the service_level_goal_percent of this LongTermRequirementsServiceGoal.
        Value of service level objective percent from service goals

        :return: The service_level_goal_percent of this LongTermRequirementsServiceGoal.
        :rtype: float
        """
        return self._service_level_goal_percent

    @service_level_goal_percent.setter
    def service_level_goal_percent(self, service_level_goal_percent: float) -> None:
        """
        Sets the service_level_goal_percent of this LongTermRequirementsServiceGoal.
        Value of service level objective percent from service goals

        :param service_level_goal_percent: The service_level_goal_percent of this LongTermRequirementsServiceGoal.
        :type: float
        """
        

        self._service_level_goal_percent = service_level_goal_percent

    @property
    def use_abandon_rate_goal(self) -> bool:
        """
        Gets the use_abandon_rate_goal of this LongTermRequirementsServiceGoal.
        Toggle for abandon rate from service goals

        :return: The use_abandon_rate_goal of this LongTermRequirementsServiceGoal.
        :rtype: bool
        """
        return self._use_abandon_rate_goal

    @use_abandon_rate_goal.setter
    def use_abandon_rate_goal(self, use_abandon_rate_goal: bool) -> None:
        """
        Sets the use_abandon_rate_goal of this LongTermRequirementsServiceGoal.
        Toggle for abandon rate from service goals

        :param use_abandon_rate_goal: The use_abandon_rate_goal of this LongTermRequirementsServiceGoal.
        :type: bool
        """
        

        self._use_abandon_rate_goal = use_abandon_rate_goal

    @property
    def abandon_rate_goal_percent(self) -> float:
        """
        Gets the abandon_rate_goal_percent of this LongTermRequirementsServiceGoal.
        Value of abandon rate objective

        :return: The abandon_rate_goal_percent of this LongTermRequirementsServiceGoal.
        :rtype: float
        """
        return self._abandon_rate_goal_percent

    @abandon_rate_goal_percent.setter
    def abandon_rate_goal_percent(self, abandon_rate_goal_percent: float) -> None:
        """
        Sets the abandon_rate_goal_percent of this LongTermRequirementsServiceGoal.
        Value of abandon rate objective

        :param abandon_rate_goal_percent: The abandon_rate_goal_percent of this LongTermRequirementsServiceGoal.
        :type: float
        """
        

        self._abandon_rate_goal_percent = abandon_rate_goal_percent

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

