# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MaskingRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MaskingRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'substitute_character': 'str',
            'definition': 'str',
            'enabled': 'bool',
            'type': 'str',
            'integrations': 'list[str]',
            'date_created': 'datetime',
            'date_modified': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'substitute_character': 'substituteCharacter',
            'definition': 'definition',
            'enabled': 'enabled',
            'type': 'type',
            'integrations': 'integrations',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified'
        }

        self._id = None
        self._name = None
        self._description = None
        self._substitute_character = None
        self._definition = None
        self._enabled = None
        self._type = None
        self._integrations = None
        self._date_created = None
        self._date_modified = None

    @property
    def id(self) -> str:
        """
        Gets the id of this MaskingRule.
        The globally unique identifier for the object.

        :return: The id of this MaskingRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this MaskingRule.
        The globally unique identifier for the object.

        :param id: The id of this MaskingRule.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this MaskingRule.
        Masking rule name.

        :return: The name of this MaskingRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this MaskingRule.
        Masking rule name.

        :param name: The name of this MaskingRule.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this MaskingRule.
        Description about masking rule.

        :return: The description of this MaskingRule.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this MaskingRule.
        Description about masking rule.

        :param description: The description of this MaskingRule.
        :type: str
        """
        

        self._description = description

    @property
    def substitute_character(self) -> str:
        """
        Gets the substitute_character of this MaskingRule.
        Replacement character for masked text character.

        :return: The substitute_character of this MaskingRule.
        :rtype: str
        """
        return self._substitute_character

    @substitute_character.setter
    def substitute_character(self, substitute_character: str) -> None:
        """
        Sets the substitute_character of this MaskingRule.
        Replacement character for masked text character.

        :param substitute_character: The substitute_character of this MaskingRule.
        :type: str
        """
        

        self._substitute_character = substitute_character

    @property
    def definition(self) -> str:
        """
        Gets the definition of this MaskingRule.
        Definition of masking rule (a valid regex or builtin AI based mask name).

        :return: The definition of this MaskingRule.
        :rtype: str
        """
        return self._definition

    @definition.setter
    def definition(self, definition: str) -> None:
        """
        Sets the definition of this MaskingRule.
        Definition of masking rule (a valid regex or builtin AI based mask name).

        :param definition: The definition of this MaskingRule.
        :type: str
        """
        

        self._definition = definition

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this MaskingRule.
        True/False

        :return: The enabled of this MaskingRule.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this MaskingRule.
        True/False

        :param enabled: The enabled of this MaskingRule.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def type(self) -> str:
        """
        Gets the type of this MaskingRule.
        Masking rule type

        :return: The type of this MaskingRule.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this MaskingRule.
        Masking rule type

        :param type: The type of this MaskingRule.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Custom", "Predefined", "Default"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def integrations(self) -> List[str]:
        """
        Gets the integrations of this MaskingRule.
        Associated integration channels

        :return: The integrations of this MaskingRule.
        :rtype: list[str]
        """
        return self._integrations

    @integrations.setter
    def integrations(self, integrations: List[str]) -> None:
        """
        Sets the integrations of this MaskingRule.
        Associated integration channels

        :param integrations: The integrations of this MaskingRule.
        :type: list[str]
        """
        

        self._integrations = integrations

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this MaskingRule.
        Date when the rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this MaskingRule.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this MaskingRule.
        Date when the rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this MaskingRule.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this MaskingRule.
        Date when the rule was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this MaskingRule.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this MaskingRule.
        Date when the rule was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this MaskingRule.
        :type: datetime
        """
        

        self._date_modified = date_modified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

