# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MaskingRuleValidateResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MaskingRuleValidateResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'valid': 'bool',
            'validation_message': 'str',
            'masked_text': 'str'
        }

        self.attribute_map = {
            'valid': 'valid',
            'validation_message': 'validationMessage',
            'masked_text': 'maskedText'
        }

        self._valid = None
        self._validation_message = None
        self._masked_text = None

    @property
    def valid(self) -> bool:
        """
        Gets the valid of this MaskingRuleValidateResponse.
        is masking rule definition valid?

        :return: The valid of this MaskingRuleValidateResponse.
        :rtype: bool
        """
        return self._valid

    @valid.setter
    def valid(self, valid: bool) -> None:
        """
        Sets the valid of this MaskingRuleValidateResponse.
        is masking rule definition valid?

        :param valid: The valid of this MaskingRuleValidateResponse.
        :type: bool
        """
        

        self._valid = valid

    @property
    def validation_message(self) -> str:
        """
        Gets the validation_message of this MaskingRuleValidateResponse.
        Validation message.

        :return: The validation_message of this MaskingRuleValidateResponse.
        :rtype: str
        """
        return self._validation_message

    @validation_message.setter
    def validation_message(self, validation_message: str) -> None:
        """
        Sets the validation_message of this MaskingRuleValidateResponse.
        Validation message.

        :param validation_message: The validation_message of this MaskingRuleValidateResponse.
        :type: str
        """
        

        self._validation_message = validation_message

    @property
    def masked_text(self) -> str:
        """
        Gets the masked_text of this MaskingRuleValidateResponse.
        Masked text.

        :return: The masked_text of this MaskingRuleValidateResponse.
        :rtype: str
        """
        return self._masked_text

    @masked_text.setter
    def masked_text(self, masked_text: str) -> None:
        """
        Sets the masked_text of this MaskingRuleValidateResponse.
        Masked text.

        :param masked_text: The masked_text of this MaskingRuleValidateResponse.
        :type: str
        """
        

        self._masked_text = masked_text

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

