# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WritableDivision

class MemberGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MemberGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'division': 'WritableDivision',
            'type': 'str',
            'member_count': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'division': 'division',
            'type': 'type',
            'member_count': 'memberCount',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._division = None
        self._type = None
        self._member_count = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this MemberGroup.
        The globally unique identifier for the object.

        :return: The id of this MemberGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this MemberGroup.
        The globally unique identifier for the object.

        :param id: The id of this MemberGroup.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this MemberGroup.


        :return: The name of this MemberGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this MemberGroup.


        :param name: The name of this MemberGroup.
        :type: str
        """
        

        self._name = name

    @property
    def division(self) -> 'WritableDivision':
        """
        Gets the division of this MemberGroup.
        The division to which this entity belongs.

        :return: The division of this MemberGroup.
        :rtype: WritableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableDivision') -> None:
        """
        Sets the division of this MemberGroup.
        The division to which this entity belongs.

        :param division: The division of this MemberGroup.
        :type: WritableDivision
        """
        

        self._division = division

    @property
    def type(self) -> str:
        """
        Gets the type of this MemberGroup.
        The group type

        :return: The type of this MemberGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this MemberGroup.
        The group type

        :param type: The type of this MemberGroup.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["TEAM", "GROUP", "SKILLGROUP"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def member_count(self) -> int:
        """
        Gets the member_count of this MemberGroup.
        The number of members in this group

        :return: The member_count of this MemberGroup.
        :rtype: int
        """
        return self._member_count

    @member_count.setter
    def member_count(self, member_count: int) -> None:
        """
        Sets the member_count of this MemberGroup.
        The number of members in this group

        :param member_count: The member_count of this MemberGroup.
        :type: int
        """
        

        self._member_count = member_count

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this MemberGroup.
        The URI for this object

        :return: The self_uri of this MemberGroup.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this MemberGroup.
        The URI for this object

        :param self_uri: The self_uri of this MemberGroup.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

