# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class MessagingConferResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MessagingConferResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation': 'AddressableEntityRef',
            'communication_id': 'str',
            'peer_communication_id': 'str',
            'command_id': 'str'
        }

        self.attribute_map = {
            'conversation': 'conversation',
            'communication_id': 'communicationId',
            'peer_communication_id': 'peerCommunicationId',
            'command_id': 'commandId'
        }

        self._conversation = None
        self._communication_id = None
        self._peer_communication_id = None
        self._command_id = None

    @property
    def conversation(self) -> 'AddressableEntityRef':
        """
        Gets the conversation of this MessagingConferResponse.
        conversation ID.

        :return: The conversation of this MessagingConferResponse.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'AddressableEntityRef') -> None:
        """
        Sets the conversation of this MessagingConferResponse.
        conversation ID.

        :param conversation: The conversation of this MessagingConferResponse.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    @property
    def communication_id(self) -> str:
        """
        Gets the communication_id of this MessagingConferResponse.
        The internal communication ID.

        :return: The communication_id of this MessagingConferResponse.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id: str) -> None:
        """
        Sets the communication_id of this MessagingConferResponse.
        The internal communication ID.

        :param communication_id: The communication_id of this MessagingConferResponse.
        :type: str
        """
        

        self._communication_id = communication_id

    @property
    def peer_communication_id(self) -> str:
        """
        Gets the peer_communication_id of this MessagingConferResponse.
        The peer internal communication ID.

        :return: The peer_communication_id of this MessagingConferResponse.
        :rtype: str
        """
        return self._peer_communication_id

    @peer_communication_id.setter
    def peer_communication_id(self, peer_communication_id: str) -> None:
        """
        Sets the peer_communication_id of this MessagingConferResponse.
        The peer internal communication ID.

        :param peer_communication_id: The peer_communication_id of this MessagingConferResponse.
        :type: str
        """
        

        self._peer_communication_id = peer_communication_id

    @property
    def command_id(self) -> str:
        """
        Gets the command_id of this MessagingConferResponse.
        Command ID for a given request.

        :return: The command_id of this MessagingConferResponse.
        :rtype: str
        """
        return self._command_id

    @command_id.setter
    def command_id(self, command_id: str) -> None:
        """
        Sets the command_id of this MessagingConferResponse.
        Command ID for a given request.

        :param command_id: The command_id of this MessagingConferResponse.
        :type: str
        """
        

        self._command_id = command_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

