# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MinerExecuteRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MinerExecuteRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_start': 'date',
            'date_end': 'date',
            'upload_key': 'str',
            'media_type': 'str',
            'participant_type': 'str',
            'queue_ids': 'list[str]'
        }

        self.attribute_map = {
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'upload_key': 'uploadKey',
            'media_type': 'mediaType',
            'participant_type': 'participantType',
            'queue_ids': 'queueIds'
        }

        self._date_start = None
        self._date_end = None
        self._upload_key = None
        self._media_type = None
        self._participant_type = None
        self._queue_ids = None

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this MinerExecuteRequest.
        Start date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this MinerExecuteRequest.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this MinerExecuteRequest.
        Start date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this MinerExecuteRequest.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this MinerExecuteRequest.
        End date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this MinerExecuteRequest.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this MinerExecuteRequest.
        End date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this MinerExecuteRequest.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def upload_key(self) -> str:
        """
        Gets the upload_key of this MinerExecuteRequest.
        Location of input conversations.

        :return: The upload_key of this MinerExecuteRequest.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key: str) -> None:
        """
        Sets the upload_key of this MinerExecuteRequest.
        Location of input conversations.

        :param upload_key: The upload_key of this MinerExecuteRequest.
        :type: str
        """
        

        self._upload_key = upload_key

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this MinerExecuteRequest.
        Media type for filtering conversations.

        :return: The media_type of this MinerExecuteRequest.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this MinerExecuteRequest.
        Media type for filtering conversations.

        :param media_type: The media_type of this MinerExecuteRequest.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Chat", "Call", "Message", "Email"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def participant_type(self) -> str:
        """
        Gets the participant_type of this MinerExecuteRequest.
        Type of the participant, either agent, customer or both.

        :return: The participant_type of this MinerExecuteRequest.
        :rtype: str
        """
        return self._participant_type

    @participant_type.setter
    def participant_type(self, participant_type: str) -> None:
        """
        Sets the participant_type of this MinerExecuteRequest.
        Type of the participant, either agent, customer or both.

        :param participant_type: The participant_type of this MinerExecuteRequest.
        :type: str
        """
        if isinstance(participant_type, int):
            participant_type = str(participant_type)
        allowed_values = ["Customer", "Agent", "Both"]
        if participant_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for participant_type -> " + participant_type)
            self._participant_type = "outdated_sdk_version"
        else:
            self._participant_type = participant_type

    @property
    def queue_ids(self) -> List[str]:
        """
        Gets the queue_ids of this MinerExecuteRequest.
        List of queue IDs for filtering conversations.

        :return: The queue_ids of this MinerExecuteRequest.
        :rtype: list[str]
        """
        return self._queue_ids

    @queue_ids.setter
    def queue_ids(self, queue_ids: List[str]) -> None:
        """
        Sets the queue_ids of this MinerExecuteRequest.
        List of queue IDs for filtering conversations.

        :param queue_ids: The queue_ids of this MinerExecuteRequest.
        :type: list[str]
        """
        

        self._queue_ids = queue_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

