# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import NamedEntityTypeItem
    from . import NamedEntityTypeMechanismExample

class NamedEntityTypeMechanism(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NamedEntityTypeMechanism - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'items': 'list[NamedEntityTypeItem]',
            'restricted': 'bool',
            'type': 'str',
            'sub_type': 'str',
            'max_length': 'int',
            'min_length': 'int',
            'allow_special_chars': 'bool',
            'examples': 'list[NamedEntityTypeMechanismExample]'
        }

        self.attribute_map = {
            'items': 'items',
            'restricted': 'restricted',
            'type': 'type',
            'sub_type': 'subType',
            'max_length': 'maxLength',
            'min_length': 'minLength',
            'allow_special_chars': 'allowSpecialChars',
            'examples': 'examples'
        }

        self._items = None
        self._restricted = None
        self._type = None
        self._sub_type = None
        self._max_length = None
        self._min_length = None
        self._allow_special_chars = None
        self._examples = None

    @property
    def items(self) -> List['NamedEntityTypeItem']:
        """
        Gets the items of this NamedEntityTypeMechanism.
        The items that define the named entity type.

        :return: The items of this NamedEntityTypeMechanism.
        :rtype: list[NamedEntityTypeItem]
        """
        return self._items

    @items.setter
    def items(self, items: List['NamedEntityTypeItem']) -> None:
        """
        Sets the items of this NamedEntityTypeMechanism.
        The items that define the named entity type.

        :param items: The items of this NamedEntityTypeMechanism.
        :type: list[NamedEntityTypeItem]
        """
        

        self._items = items

    @property
    def restricted(self) -> bool:
        """
        Gets the restricted of this NamedEntityTypeMechanism.
        Whether the named entity type is restricted to the items provided. Default: false

        :return: The restricted of this NamedEntityTypeMechanism.
        :rtype: bool
        """
        return self._restricted

    @restricted.setter
    def restricted(self, restricted: bool) -> None:
        """
        Sets the restricted of this NamedEntityTypeMechanism.
        Whether the named entity type is restricted to the items provided. Default: false

        :param restricted: The restricted of this NamedEntityTypeMechanism.
        :type: bool
        """
        

        self._restricted = restricted

    @property
    def type(self) -> str:
        """
        Gets the type of this NamedEntityTypeMechanism.
        The type of the mechanism.

        :return: The type of this NamedEntityTypeMechanism.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this NamedEntityTypeMechanism.
        The type of the mechanism.

        :param type: The type of this NamedEntityTypeMechanism.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["AI", "DynamicDateTime", "DynamicList", "List", "Regex", "Unknown"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def sub_type(self) -> str:
        """
        Gets the sub_type of this NamedEntityTypeMechanism.
        Subtype of detection mechanism

        :return: The sub_type of this NamedEntityTypeMechanism.
        :rtype: str
        """
        return self._sub_type

    @sub_type.setter
    def sub_type(self, sub_type: str) -> None:
        """
        Sets the sub_type of this NamedEntityTypeMechanism.
        Subtype of detection mechanism

        :param sub_type: The sub_type of this NamedEntityTypeMechanism.
        :type: str
        """
        if isinstance(sub_type, int):
            sub_type = str(sub_type)
        allowed_values = ["Alphanumeric", "NumberSequence", "FreeForm"]
        if sub_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sub_type -> " + sub_type)
            self._sub_type = "outdated_sdk_version"
        else:
            self._sub_type = sub_type

    @property
    def max_length(self) -> int:
        """
        Gets the max_length of this NamedEntityTypeMechanism.
        The maximum length of the entity resolved value

        :return: The max_length of this NamedEntityTypeMechanism.
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length: int) -> None:
        """
        Sets the max_length of this NamedEntityTypeMechanism.
        The maximum length of the entity resolved value

        :param max_length: The max_length of this NamedEntityTypeMechanism.
        :type: int
        """
        

        self._max_length = max_length

    @property
    def min_length(self) -> int:
        """
        Gets the min_length of this NamedEntityTypeMechanism.
        The minimum length of the entity resolved value

        :return: The min_length of this NamedEntityTypeMechanism.
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length: int) -> None:
        """
        Sets the min_length of this NamedEntityTypeMechanism.
        The minimum length of the entity resolved value

        :param min_length: The min_length of this NamedEntityTypeMechanism.
        :type: int
        """
        

        self._min_length = min_length

    @property
    def allow_special_chars(self) -> bool:
        """
        Gets the allow_special_chars of this NamedEntityTypeMechanism.
        Flag whether to allow for special characters during AI slot capture

        :return: The allow_special_chars of this NamedEntityTypeMechanism.
        :rtype: bool
        """
        return self._allow_special_chars

    @allow_special_chars.setter
    def allow_special_chars(self, allow_special_chars: bool) -> None:
        """
        Sets the allow_special_chars of this NamedEntityTypeMechanism.
        Flag whether to allow for special characters during AI slot capture

        :param allow_special_chars: The allow_special_chars of this NamedEntityTypeMechanism.
        :type: bool
        """
        

        self._allow_special_chars = allow_special_chars

    @property
    def examples(self) -> List['NamedEntityTypeMechanismExample']:
        """
        Gets the examples of this NamedEntityTypeMechanism.
        Examples for entity detection

        :return: The examples of this NamedEntityTypeMechanism.
        :rtype: list[NamedEntityTypeMechanismExample]
        """
        return self._examples

    @examples.setter
    def examples(self, examples: List['NamedEntityTypeMechanismExample']) -> None:
        """
        Sets the examples of this NamedEntityTypeMechanism.
        Examples for entity detection

        :param examples: The examples of this NamedEntityTypeMechanism.
        :type: list[NamedEntityTypeMechanismExample]
        """
        

        self._examples = examples

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

