# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OccurrenceDetails

class NextOccurrenceDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NextOccurrenceDetails - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_occurrence_details': 'OccurrenceDetails',
            'end_occurrence_details': 'OccurrenceDetails'
        }

        self.attribute_map = {
            'start_occurrence_details': 'startOccurrenceDetails',
            'end_occurrence_details': 'endOccurrenceDetails'
        }

        self._start_occurrence_details = None
        self._end_occurrence_details = None

    @property
    def start_occurrence_details(self) -> 'OccurrenceDetails':
        """
        Gets the start_occurrence_details of this NextOccurrenceDetails.
        The details for the next start occurrence for the recurrence.

        :return: The start_occurrence_details of this NextOccurrenceDetails.
        :rtype: OccurrenceDetails
        """
        return self._start_occurrence_details

    @start_occurrence_details.setter
    def start_occurrence_details(self, start_occurrence_details: 'OccurrenceDetails') -> None:
        """
        Sets the start_occurrence_details of this NextOccurrenceDetails.
        The details for the next start occurrence for the recurrence.

        :param start_occurrence_details: The start_occurrence_details of this NextOccurrenceDetails.
        :type: OccurrenceDetails
        """
        

        self._start_occurrence_details = start_occurrence_details

    @property
    def end_occurrence_details(self) -> 'OccurrenceDetails':
        """
        Gets the end_occurrence_details of this NextOccurrenceDetails.
        The details for the next end occurrence for the recurrence.

        :return: The end_occurrence_details of this NextOccurrenceDetails.
        :rtype: OccurrenceDetails
        """
        return self._end_occurrence_details

    @end_occurrence_details.setter
    def end_occurrence_details(self, end_occurrence_details: 'OccurrenceDetails') -> None:
        """
        Sets the end_occurrence_details of this NextOccurrenceDetails.
        The details for the next end occurrence for the recurrence.

        :param end_occurrence_details: The end_occurrence_details of this NextOccurrenceDetails.
        :type: OccurrenceDetails
        """
        

        self._end_occurrence_details = end_occurrence_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

