# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import NluConfusionMatrixRow
    from . import NluDomainVersion
    from . import NluQualityReportSummary

class NluDomainVersionQualityReport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NluDomainVersionQualityReport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'version': 'NluDomainVersion',
            'confusion_matrix': 'list[NluConfusionMatrixRow]',
            'summary': 'NluQualityReportSummary'
        }

        self.attribute_map = {
            'version': 'version',
            'confusion_matrix': 'confusionMatrix',
            'summary': 'summary'
        }

        self._version = None
        self._confusion_matrix = None
        self._summary = None

    @property
    def version(self) -> 'NluDomainVersion':
        """
        Gets the version of this NluDomainVersionQualityReport.
        The domain and version details of the quality report

        :return: The version of this NluDomainVersionQualityReport.
        :rtype: NluDomainVersion
        """
        return self._version

    @version.setter
    def version(self, version: 'NluDomainVersion') -> None:
        """
        Sets the version of this NluDomainVersionQualityReport.
        The domain and version details of the quality report

        :param version: The version of this NluDomainVersionQualityReport.
        :type: NluDomainVersion
        """
        

        self._version = version

    @property
    def confusion_matrix(self) -> List['NluConfusionMatrixRow']:
        """
        Gets the confusion_matrix of this NluDomainVersionQualityReport.
        The confusion matrix for the Domain Version

        :return: The confusion_matrix of this NluDomainVersionQualityReport.
        :rtype: list[NluConfusionMatrixRow]
        """
        return self._confusion_matrix

    @confusion_matrix.setter
    def confusion_matrix(self, confusion_matrix: List['NluConfusionMatrixRow']) -> None:
        """
        Sets the confusion_matrix of this NluDomainVersionQualityReport.
        The confusion matrix for the Domain Version

        :param confusion_matrix: The confusion_matrix of this NluDomainVersionQualityReport.
        :type: list[NluConfusionMatrixRow]
        """
        

        self._confusion_matrix = confusion_matrix

    @property
    def summary(self) -> 'NluQualityReportSummary':
        """
        Gets the summary of this NluDomainVersionQualityReport.
        The quality report summary for the Domain Version

        :return: The summary of this NluDomainVersionQualityReport.
        :rtype: NluQualityReportSummary
        """
        return self._summary

    @summary.setter
    def summary(self, summary: 'NluQualityReportSummary') -> None:
        """
        Sets the summary of this NluDomainVersionQualityReport.
        The quality report summary for the Domain Version

        :param summary: The summary of this NluDomainVersionQualityReport.
        :type: NluQualityReportSummary
        """
        

        self._summary = summary

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

