# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import IntentReference
    from . import NluDomain

class NluDomainVersionReference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NluDomainVersionReference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'domain': 'NluDomain',
            'intents': 'list[IntentReference]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'domain': 'domain',
            'intents': 'intents',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._domain = None
        self._intents = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this NluDomainVersionReference.
        The globally unique identifier for the object.

        :return: The id of this NluDomainVersionReference.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this NluDomainVersionReference.
        The globally unique identifier for the object.

        :param id: The id of this NluDomainVersionReference.
        :type: str
        """
        

        self._id = id

    @property
    def domain(self) -> 'NluDomain':
        """
        Gets the domain of this NluDomainVersionReference.
        The NLU domain of the version.

        :return: The domain of this NluDomainVersionReference.
        :rtype: NluDomain
        """
        return self._domain

    @domain.setter
    def domain(self, domain: 'NluDomain') -> None:
        """
        Sets the domain of this NluDomainVersionReference.
        The NLU domain of the version.

        :param domain: The domain of this NluDomainVersionReference.
        :type: NluDomain
        """
        

        self._domain = domain

    @property
    def intents(self) -> List['IntentReference']:
        """
        Gets the intents of this NluDomainVersionReference.
        The intents defined for this NLU domain version.

        :return: The intents of this NluDomainVersionReference.
        :rtype: list[IntentReference]
        """
        return self._intents

    @intents.setter
    def intents(self, intents: List['IntentReference']) -> None:
        """
        Sets the intents of this NluDomainVersionReference.
        The intents defined for this NLU domain version.

        :param intents: The intents of this NluDomainVersionReference.
        :type: list[IntentReference]
        """
        

        self._intents = intents

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this NluDomainVersionReference.
        The URI for this object

        :return: The self_uri of this NluDomainVersionReference.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this NluDomainVersionReference.
        The URI for this object

        :param self_uri: The self_uri of this NluDomainVersionReference.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

