# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import RoleDivision

class OAuthClientRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OAuthClientRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'access_token_validity_seconds': 'int',
            'description': 'str',
            'registered_redirect_uri': 'list[str]',
            'role_ids': 'list[str]',
            'authorized_grant_type': 'str',
            'scope': 'list[str]',
            'role_divisions': 'list[RoleDivision]',
            'state': 'str',
            'date_to_delete': 'datetime'
        }

        self.attribute_map = {
            'name': 'name',
            'access_token_validity_seconds': 'accessTokenValiditySeconds',
            'description': 'description',
            'registered_redirect_uri': 'registeredRedirectUri',
            'role_ids': 'roleIds',
            'authorized_grant_type': 'authorizedGrantType',
            'scope': 'scope',
            'role_divisions': 'roleDivisions',
            'state': 'state',
            'date_to_delete': 'dateToDelete'
        }

        self._name = None
        self._access_token_validity_seconds = None
        self._description = None
        self._registered_redirect_uri = None
        self._role_ids = None
        self._authorized_grant_type = None
        self._scope = None
        self._role_divisions = None
        self._state = None
        self._date_to_delete = None

    @property
    def name(self) -> str:
        """
        Gets the name of this OAuthClientRequest.
        The name of the OAuth client.

        :return: The name of this OAuthClientRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this OAuthClientRequest.
        The name of the OAuth client.

        :param name: The name of this OAuthClientRequest.
        :type: str
        """
        

        self._name = name

    @property
    def access_token_validity_seconds(self) -> int:
        """
        Gets the access_token_validity_seconds of this OAuthClientRequest.
        The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.

        :return: The access_token_validity_seconds of this OAuthClientRequest.
        :rtype: int
        """
        return self._access_token_validity_seconds

    @access_token_validity_seconds.setter
    def access_token_validity_seconds(self, access_token_validity_seconds: int) -> None:
        """
        Sets the access_token_validity_seconds of this OAuthClientRequest.
        The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.

        :param access_token_validity_seconds: The access_token_validity_seconds of this OAuthClientRequest.
        :type: int
        """
        

        self._access_token_validity_seconds = access_token_validity_seconds

    @property
    def description(self) -> str:
        """
        Gets the description of this OAuthClientRequest.


        :return: The description of this OAuthClientRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this OAuthClientRequest.


        :param description: The description of this OAuthClientRequest.
        :type: str
        """
        

        self._description = description

    @property
    def registered_redirect_uri(self) -> List[str]:
        """
        Gets the registered_redirect_uri of this OAuthClientRequest.
        List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback

        :return: The registered_redirect_uri of this OAuthClientRequest.
        :rtype: list[str]
        """
        return self._registered_redirect_uri

    @registered_redirect_uri.setter
    def registered_redirect_uri(self, registered_redirect_uri: List[str]) -> None:
        """
        Sets the registered_redirect_uri of this OAuthClientRequest.
        List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback

        :param registered_redirect_uri: The registered_redirect_uri of this OAuthClientRequest.
        :type: list[str]
        """
        

        self._registered_redirect_uri = registered_redirect_uri

    @property
    def role_ids(self) -> List[str]:
        """
        Gets the role_ids of this OAuthClientRequest.
        Deprecated. Use roleDivisions instead.

        :return: The role_ids of this OAuthClientRequest.
        :rtype: list[str]
        """
        return self._role_ids

    @role_ids.setter
    def role_ids(self, role_ids: List[str]) -> None:
        """
        Sets the role_ids of this OAuthClientRequest.
        Deprecated. Use roleDivisions instead.

        :param role_ids: The role_ids of this OAuthClientRequest.
        :type: list[str]
        """
        

        self._role_ids = role_ids

    @property
    def authorized_grant_type(self) -> str:
        """
        Gets the authorized_grant_type of this OAuthClientRequest.
        The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. PKCE-Enabled Code Authorization grant type - Code grant type which requires PKCE challenge and verifier to create tokens. Used in public clients for increased security. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. 

        :return: The authorized_grant_type of this OAuthClientRequest.
        :rtype: str
        """
        return self._authorized_grant_type

    @authorized_grant_type.setter
    def authorized_grant_type(self, authorized_grant_type: str) -> None:
        """
        Sets the authorized_grant_type of this OAuthClientRequest.
        The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. PKCE-Enabled Code Authorization grant type - Code grant type which requires PKCE challenge and verifier to create tokens. Used in public clients for increased security. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. 

        :param authorized_grant_type: The authorized_grant_type of this OAuthClientRequest.
        :type: str
        """
        if isinstance(authorized_grant_type, int):
            authorized_grant_type = str(authorized_grant_type)
        allowed_values = ["CODE", "TOKEN", "SAML2-BEARER", "PASSWORD", "CLIENT-CREDENTIALS"]
        if authorized_grant_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for authorized_grant_type -> " + authorized_grant_type)
            self._authorized_grant_type = "outdated_sdk_version"
        else:
            self._authorized_grant_type = authorized_grant_type

    @property
    def scope(self) -> List[str]:
        """
        Gets the scope of this OAuthClientRequest.
        The scope requested by this client. Scopes only apply to clients not using the client_credential grant

        :return: The scope of this OAuthClientRequest.
        :rtype: list[str]
        """
        return self._scope

    @scope.setter
    def scope(self, scope: List[str]) -> None:
        """
        Sets the scope of this OAuthClientRequest.
        The scope requested by this client. Scopes only apply to clients not using the client_credential grant

        :param scope: The scope of this OAuthClientRequest.
        :type: list[str]
        """
        

        self._scope = scope

    @property
    def role_divisions(self) -> List['RoleDivision']:
        """
        Gets the role_divisions of this OAuthClientRequest.
        Set of roles and their corresponding divisions associated with this client. Roles and divisions only apply to clients using the client_credential grant

        :return: The role_divisions of this OAuthClientRequest.
        :rtype: list[RoleDivision]
        """
        return self._role_divisions

    @role_divisions.setter
    def role_divisions(self, role_divisions: List['RoleDivision']) -> None:
        """
        Sets the role_divisions of this OAuthClientRequest.
        Set of roles and their corresponding divisions associated with this client. Roles and divisions only apply to clients using the client_credential grant

        :param role_divisions: The role_divisions of this OAuthClientRequest.
        :type: list[RoleDivision]
        """
        

        self._role_divisions = role_divisions

    @property
    def state(self) -> str:
        """
        Gets the state of this OAuthClientRequest.
        The state of the OAuth client. Active: The OAuth client can be used to create access tokens. This is the default state. Disabled: Access tokens created by the client are invalid and new ones cannot be created. Inactive: Access tokens cannot be created with this OAuth client and it will be deleted.

        :return: The state of this OAuthClientRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this OAuthClientRequest.
        The state of the OAuth client. Active: The OAuth client can be used to create access tokens. This is the default state. Disabled: Access tokens created by the client are invalid and new ones cannot be created. Inactive: Access tokens cannot be created with this OAuth client and it will be deleted.

        :param state: The state of this OAuthClientRequest.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["active", "disabled", "inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_to_delete(self) -> datetime:
        """
        Gets the date_to_delete of this OAuthClientRequest.
        The time at which this client will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_to_delete of this OAuthClientRequest.
        :rtype: datetime
        """
        return self._date_to_delete

    @date_to_delete.setter
    def date_to_delete(self, date_to_delete: datetime) -> None:
        """
        Sets the date_to_delete of this OAuthClientRequest.
        The time at which this client will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_to_delete: The date_to_delete of this OAuthClientRequest.
        :type: datetime
        """
        

        self._date_to_delete = date_to_delete

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

