# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ObservationValue
    from . import StatisticalSummary

class ObservationMetricData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ObservationMetricData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric': 'str',
            'qualifier': 'str',
            'stats': 'StatisticalSummary',
            'truncated': 'bool',
            'observations': 'list[ObservationValue]'
        }

        self.attribute_map = {
            'metric': 'metric',
            'qualifier': 'qualifier',
            'stats': 'stats',
            'truncated': 'truncated',
            'observations': 'observations'
        }

        self._metric = None
        self._qualifier = None
        self._stats = None
        self._truncated = None
        self._observations = None

    @property
    def metric(self) -> str:
        """
        Gets the metric of this ObservationMetricData.


        :return: The metric of this ObservationMetricData.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this ObservationMetricData.


        :param metric: The metric of this ObservationMetricData.
        :type: str
        """
        

        self._metric = metric

    @property
    def qualifier(self) -> str:
        """
        Gets the qualifier of this ObservationMetricData.


        :return: The qualifier of this ObservationMetricData.
        :rtype: str
        """
        return self._qualifier

    @qualifier.setter
    def qualifier(self, qualifier: str) -> None:
        """
        Sets the qualifier of this ObservationMetricData.


        :param qualifier: The qualifier of this ObservationMetricData.
        :type: str
        """
        

        self._qualifier = qualifier

    @property
    def stats(self) -> 'StatisticalSummary':
        """
        Gets the stats of this ObservationMetricData.


        :return: The stats of this ObservationMetricData.
        :rtype: StatisticalSummary
        """
        return self._stats

    @stats.setter
    def stats(self, stats: 'StatisticalSummary') -> None:
        """
        Sets the stats of this ObservationMetricData.


        :param stats: The stats of this ObservationMetricData.
        :type: StatisticalSummary
        """
        

        self._stats = stats

    @property
    def truncated(self) -> bool:
        """
        Gets the truncated of this ObservationMetricData.
        Flag for a truncated list of observations. If truncated, the first half of the list of observations will contain the oldest observations and the second half the newest observations.

        :return: The truncated of this ObservationMetricData.
        :rtype: bool
        """
        return self._truncated

    @truncated.setter
    def truncated(self, truncated: bool) -> None:
        """
        Sets the truncated of this ObservationMetricData.
        Flag for a truncated list of observations. If truncated, the first half of the list of observations will contain the oldest observations and the second half the newest observations.

        :param truncated: The truncated of this ObservationMetricData.
        :type: bool
        """
        

        self._truncated = truncated

    @property
    def observations(self) -> List['ObservationValue']:
        """
        Gets the observations of this ObservationMetricData.
        List of observations sorted by timestamp in ascending order. This list may be truncated.

        :return: The observations of this ObservationMetricData.
        :rtype: list[ObservationValue]
        """
        return self._observations

    @observations.setter
    def observations(self, observations: List['ObservationValue']) -> None:
        """
        Sets the observations of this ObservationMetricData.
        List of observations sorted by timestamp in ascending order. This list may be truncated.

        :param observations: The observations of this ObservationMetricData.
        :type: list[ObservationValue]
        """
        

        self._observations = observations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

