# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenMessagingFromRecipient

class OpenInboundMessagingChannel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenInboundMessagingChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'pcFrom': 'OpenMessagingFromRecipient',
            'time': 'datetime'
        }

        self.attribute_map = {
            'pcFrom': 'from',
            'time': 'time'
        }

        self._pcFrom = None
        self._time = None

    @property
    def pcFrom(self) -> 'OpenMessagingFromRecipient':
        """
        Gets the pcFrom of this OpenInboundMessagingChannel.
        Information about the recipient the message is received from.

        :return: The pcFrom of this OpenInboundMessagingChannel.
        :rtype: OpenMessagingFromRecipient
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: 'OpenMessagingFromRecipient') -> None:
        """
        Sets the pcFrom of this OpenInboundMessagingChannel.
        Information about the recipient the message is received from.

        :param pcFrom: The pcFrom of this OpenInboundMessagingChannel.
        :type: OpenMessagingFromRecipient
        """
        

        self._pcFrom = pcFrom

    @property
    def time(self) -> datetime:
        """
        Gets the time of this OpenInboundMessagingChannel.
        Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The time of this OpenInboundMessagingChannel.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time: datetime) -> None:
        """
        Sets the time of this OpenInboundMessagingChannel.
        Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param time: The time of this OpenInboundMessagingChannel.
        :type: datetime
        """
        

        self._time = time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

