# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenInboundMessageContent
    from . import OpenInboundMessageMessagingChannel

class OpenInboundNormalizedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenInboundNormalizedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'channel': 'OpenInboundMessageMessagingChannel',
            'text': 'str',
            'content': 'list[OpenInboundMessageContent]',
            'metadata': 'dict(str, str)'
        }

        self.attribute_map = {
            'channel': 'channel',
            'text': 'text',
            'content': 'content',
            'metadata': 'metadata'
        }

        self._channel = None
        self._text = None
        self._content = None
        self._metadata = None

    @property
    def channel(self) -> 'OpenInboundMessageMessagingChannel':
        """
        Gets the channel of this OpenInboundNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :return: The channel of this OpenInboundNormalizedMessage.
        :rtype: OpenInboundMessageMessagingChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'OpenInboundMessageMessagingChannel') -> None:
        """
        Sets the channel of this OpenInboundNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :param channel: The channel of this OpenInboundNormalizedMessage.
        :type: OpenInboundMessageMessagingChannel
        """
        

        self._channel = channel

    @property
    def text(self) -> str:
        """
        Gets the text of this OpenInboundNormalizedMessage.
        Message text.

        :return: The text of this OpenInboundNormalizedMessage.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this OpenInboundNormalizedMessage.
        Message text.

        :param text: The text of this OpenInboundNormalizedMessage.
        :type: str
        """
        

        self._text = text

    @property
    def content(self) -> List['OpenInboundMessageContent']:
        """
        Gets the content of this OpenInboundNormalizedMessage.
        List of content elements.

        :return: The content of this OpenInboundNormalizedMessage.
        :rtype: list[OpenInboundMessageContent]
        """
        return self._content

    @content.setter
    def content(self, content: List['OpenInboundMessageContent']) -> None:
        """
        Sets the content of this OpenInboundNormalizedMessage.
        List of content elements.

        :param content: The content of this OpenInboundNormalizedMessage.
        :type: list[OpenInboundMessageContent]
        """
        

        self._content = content

    @property
    def metadata(self) -> Dict[str, str]:
        """
        Gets the metadata of this OpenInboundNormalizedMessage.
        Additional metadata about this message to capture non-channel specific data.

        :return: The metadata of this OpenInboundNormalizedMessage.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: Dict[str, str]) -> None:
        """
        Sets the metadata of this OpenInboundNormalizedMessage.
        Additional metadata about this message to capture non-channel specific data.

        :param metadata: The metadata of this OpenInboundNormalizedMessage.
        :type: dict(str, str)
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

