# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationReason
    from . import OpenInboundMessagingReceiptChannel

class OpenInboundNormalizedReceipt(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenInboundNormalizedReceipt - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'channel': 'OpenInboundMessagingReceiptChannel',
            'status': 'str',
            'reasons': 'list[ConversationReason]',
            'is_final_receipt': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'channel': 'channel',
            'status': 'status',
            'reasons': 'reasons',
            'is_final_receipt': 'isFinalReceipt'
        }

        self._id = None
        self._channel = None
        self._status = None
        self._reasons = None
        self._is_final_receipt = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenInboundNormalizedReceipt.
        The original unique message Id generated by the messaging platform, that this receipt message is referencing.

        :return: The id of this OpenInboundNormalizedReceipt.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenInboundNormalizedReceipt.
        The original unique message Id generated by the messaging platform, that this receipt message is referencing.

        :param id: The id of this OpenInboundNormalizedReceipt.
        :type: str
        """
        

        self._id = id

    @property
    def channel(self) -> 'OpenInboundMessagingReceiptChannel':
        """
        Gets the channel of this OpenInboundNormalizedReceipt.
        Channel-specific information that describes the message and the message channel/provider.

        :return: The channel of this OpenInboundNormalizedReceipt.
        :rtype: OpenInboundMessagingReceiptChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'OpenInboundMessagingReceiptChannel') -> None:
        """
        Sets the channel of this OpenInboundNormalizedReceipt.
        Channel-specific information that describes the message and the message channel/provider.

        :param channel: The channel of this OpenInboundNormalizedReceipt.
        :type: OpenInboundMessagingReceiptChannel
        """
        

        self._channel = channel

    @property
    def status(self) -> str:
        """
        Gets the status of this OpenInboundNormalizedReceipt.
        Message receipt status.

        :return: The status of this OpenInboundNormalizedReceipt.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this OpenInboundNormalizedReceipt.
        Message receipt status.

        :param status: The status of this OpenInboundNormalizedReceipt.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Sent", "Delivered", "Failed", "Published", "Removed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def reasons(self) -> List['ConversationReason']:
        """
        Gets the reasons of this OpenInboundNormalizedReceipt.
        List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.

        :return: The reasons of this OpenInboundNormalizedReceipt.
        :rtype: list[ConversationReason]
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons: List['ConversationReason']) -> None:
        """
        Sets the reasons of this OpenInboundNormalizedReceipt.
        List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.

        :param reasons: The reasons of this OpenInboundNormalizedReceipt.
        :type: list[ConversationReason]
        """
        

        self._reasons = reasons

    @property
    def is_final_receipt(self) -> bool:
        """
        Gets the is_final_receipt of this OpenInboundNormalizedReceipt.
        Indicates if this is the last message receipt for this message, or if another message receipt can be expected.

        :return: The is_final_receipt of this OpenInboundNormalizedReceipt.
        :rtype: bool
        """
        return self._is_final_receipt

    @is_final_receipt.setter
    def is_final_receipt(self, is_final_receipt: bool) -> None:
        """
        Sets the is_final_receipt of this OpenInboundNormalizedReceipt.
        Indicates if this is the last message receipt for this message, or if another message receipt can be expected.

        :param is_final_receipt: The is_final_receipt of this OpenInboundNormalizedReceipt.
        :type: bool
        """
        

        self._is_final_receipt = is_final_receipt

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

