# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import ErrorBody
    from . import MessagingSettingReference
    from . import SupportedContentReference

class OpenIntegration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenIntegration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'supported_content': 'SupportedContentReference',
            'messaging_setting': 'MessagingSettingReference',
            'outbound_notification_webhook_url': 'str',
            'outbound_notification_webhook_signature_secret_token': 'str',
            'webhook_headers': 'dict(str, str)',
            'status': 'str',
            'recipient': 'DomainEntityRef',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'created_by': 'DomainEntityRef',
            'modified_by': 'DomainEntityRef',
            'create_status': 'str',
            'create_error': 'ErrorBody',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'supported_content': 'supportedContent',
            'messaging_setting': 'messagingSetting',
            'outbound_notification_webhook_url': 'outboundNotificationWebhookUrl',
            'outbound_notification_webhook_signature_secret_token': 'outboundNotificationWebhookSignatureSecretToken',
            'webhook_headers': 'webhookHeaders',
            'status': 'status',
            'recipient': 'recipient',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'created_by': 'createdBy',
            'modified_by': 'modifiedBy',
            'create_status': 'createStatus',
            'create_error': 'createError',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._supported_content = None
        self._messaging_setting = None
        self._outbound_notification_webhook_url = None
        self._outbound_notification_webhook_signature_secret_token = None
        self._webhook_headers = None
        self._status = None
        self._recipient = None
        self._date_created = None
        self._date_modified = None
        self._created_by = None
        self._modified_by = None
        self._create_status = None
        self._create_error = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenIntegration.
        A unique Integration Id.

        :return: The id of this OpenIntegration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenIntegration.
        A unique Integration Id.

        :param id: The id of this OpenIntegration.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this OpenIntegration.
        The name of the Open messaging integration.

        :return: The name of this OpenIntegration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this OpenIntegration.
        The name of the Open messaging integration.

        :param name: The name of this OpenIntegration.
        :type: str
        """
        

        self._name = name

    @property
    def supported_content(self) -> 'SupportedContentReference':
        """
        Gets the supported_content of this OpenIntegration.
        Defines the SupportedContent profile configured for an integration

        :return: The supported_content of this OpenIntegration.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content: 'SupportedContentReference') -> None:
        """
        Sets the supported_content of this OpenIntegration.
        Defines the SupportedContent profile configured for an integration

        :param supported_content: The supported_content of this OpenIntegration.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def messaging_setting(self) -> 'MessagingSettingReference':
        """
        Gets the messaging_setting of this OpenIntegration.


        :return: The messaging_setting of this OpenIntegration.
        :rtype: MessagingSettingReference
        """
        return self._messaging_setting

    @messaging_setting.setter
    def messaging_setting(self, messaging_setting: 'MessagingSettingReference') -> None:
        """
        Sets the messaging_setting of this OpenIntegration.


        :param messaging_setting: The messaging_setting of this OpenIntegration.
        :type: MessagingSettingReference
        """
        

        self._messaging_setting = messaging_setting

    @property
    def outbound_notification_webhook_url(self) -> str:
        """
        Gets the outbound_notification_webhook_url of this OpenIntegration.
        The outbound notification webhook URL for the Open messaging integration.

        :return: The outbound_notification_webhook_url of this OpenIntegration.
        :rtype: str
        """
        return self._outbound_notification_webhook_url

    @outbound_notification_webhook_url.setter
    def outbound_notification_webhook_url(self, outbound_notification_webhook_url: str) -> None:
        """
        Sets the outbound_notification_webhook_url of this OpenIntegration.
        The outbound notification webhook URL for the Open messaging integration.

        :param outbound_notification_webhook_url: The outbound_notification_webhook_url of this OpenIntegration.
        :type: str
        """
        

        self._outbound_notification_webhook_url = outbound_notification_webhook_url

    @property
    def outbound_notification_webhook_signature_secret_token(self) -> str:
        """
        Gets the outbound_notification_webhook_signature_secret_token of this OpenIntegration.
        The outbound notification webhook signature secret token.

        :return: The outbound_notification_webhook_signature_secret_token of this OpenIntegration.
        :rtype: str
        """
        return self._outbound_notification_webhook_signature_secret_token

    @outbound_notification_webhook_signature_secret_token.setter
    def outbound_notification_webhook_signature_secret_token(self, outbound_notification_webhook_signature_secret_token: str) -> None:
        """
        Sets the outbound_notification_webhook_signature_secret_token of this OpenIntegration.
        The outbound notification webhook signature secret token.

        :param outbound_notification_webhook_signature_secret_token: The outbound_notification_webhook_signature_secret_token of this OpenIntegration.
        :type: str
        """
        

        self._outbound_notification_webhook_signature_secret_token = outbound_notification_webhook_signature_secret_token

    @property
    def webhook_headers(self) -> Dict[str, str]:
        """
        Gets the webhook_headers of this OpenIntegration.
        The user specified headers for the Open messaging integration.

        :return: The webhook_headers of this OpenIntegration.
        :rtype: dict(str, str)
        """
        return self._webhook_headers

    @webhook_headers.setter
    def webhook_headers(self, webhook_headers: Dict[str, str]) -> None:
        """
        Sets the webhook_headers of this OpenIntegration.
        The user specified headers for the Open messaging integration.

        :param webhook_headers: The webhook_headers of this OpenIntegration.
        :type: dict(str, str)
        """
        

        self._webhook_headers = webhook_headers

    @property
    def status(self) -> str:
        """
        Gets the status of this OpenIntegration.
        The status of the Open Integration

        :return: The status of this OpenIntegration.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this OpenIntegration.
        The status of the Open Integration

        :param status: The status of this OpenIntegration.
        :type: str
        """
        

        self._status = status

    @property
    def recipient(self) -> 'DomainEntityRef':
        """
        Gets the recipient of this OpenIntegration.
        The recipient associated to the Open messaging Integration. This recipient is used to associate a flow to an integration

        :return: The recipient of this OpenIntegration.
        :rtype: DomainEntityRef
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient: 'DomainEntityRef') -> None:
        """
        Sets the recipient of this OpenIntegration.
        The recipient associated to the Open messaging Integration. This recipient is used to associate a flow to an integration

        :param recipient: The recipient of this OpenIntegration.
        :type: DomainEntityRef
        """
        

        self._recipient = recipient

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this OpenIntegration.
        Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this OpenIntegration.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this OpenIntegration.
        Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this OpenIntegration.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this OpenIntegration.
        Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this OpenIntegration.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this OpenIntegration.
        Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this OpenIntegration.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def created_by(self) -> 'DomainEntityRef':
        """
        Gets the created_by of this OpenIntegration.
        User reference that created this Integration

        :return: The created_by of this OpenIntegration.
        :rtype: DomainEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'DomainEntityRef') -> None:
        """
        Sets the created_by of this OpenIntegration.
        User reference that created this Integration

        :param created_by: The created_by of this OpenIntegration.
        :type: DomainEntityRef
        """
        

        self._created_by = created_by

    @property
    def modified_by(self) -> 'DomainEntityRef':
        """
        Gets the modified_by of this OpenIntegration.
        User reference that last modified this Integration

        :return: The modified_by of this OpenIntegration.
        :rtype: DomainEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'DomainEntityRef') -> None:
        """
        Sets the modified_by of this OpenIntegration.
        User reference that last modified this Integration

        :param modified_by: The modified_by of this OpenIntegration.
        :type: DomainEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def create_status(self) -> str:
        """
        Gets the create_status of this OpenIntegration.
        Status of asynchronous create operation

        :return: The create_status of this OpenIntegration.
        :rtype: str
        """
        return self._create_status

    @create_status.setter
    def create_status(self, create_status: str) -> None:
        """
        Sets the create_status of this OpenIntegration.
        Status of asynchronous create operation

        :param create_status: The create_status of this OpenIntegration.
        :type: str
        """
        if isinstance(create_status, int):
            create_status = str(create_status)
        allowed_values = ["Initiated", "Completed", "Error"]
        if create_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for create_status -> " + create_status)
            self._create_status = "outdated_sdk_version"
        else:
            self._create_status = create_status

    @property
    def create_error(self) -> 'ErrorBody':
        """
        Gets the create_error of this OpenIntegration.
        Error information returned, if createStatus is set to Error

        :return: The create_error of this OpenIntegration.
        :rtype: ErrorBody
        """
        return self._create_error

    @create_error.setter
    def create_error(self, create_error: 'ErrorBody') -> None:
        """
        Sets the create_error of this OpenIntegration.
        Error information returned, if createStatus is set to Error

        :param create_error: The create_error of this OpenIntegration.
        :type: ErrorBody
        """
        

        self._create_error = create_error

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this OpenIntegration.
        The URI for this object

        :return: The self_uri of this OpenIntegration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this OpenIntegration.
        The URI for this object

        :param self_uri: The self_uri of this OpenIntegration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

