# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenSocialMediaRecipient

class OpenSocialMediaReactionsChannel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenSocialMediaReactionsChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'platform': 'str',
            'type': 'str',
            'message_id': 'str',
            'to': 'OpenSocialMediaRecipient',
            'time': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'platform': 'platform',
            'type': 'type',
            'message_id': 'messageId',
            'to': 'to',
            'time': 'time'
        }

        self._id = None
        self._platform = None
        self._type = None
        self._message_id = None
        self._to = None
        self._time = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenSocialMediaReactionsChannel.
        The topic ID.

        :return: The id of this OpenSocialMediaReactionsChannel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenSocialMediaReactionsChannel.
        The topic ID.

        :param id: The id of this OpenSocialMediaReactionsChannel.
        :type: str
        """
        

        self._id = id

    @property
    def platform(self) -> str:
        """
        Gets the platform of this OpenSocialMediaReactionsChannel.
        The provider type.

        :return: The platform of this OpenSocialMediaReactionsChannel.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform: str) -> None:
        """
        Sets the platform of this OpenSocialMediaReactionsChannel.
        The provider type.

        :param platform: The platform of this OpenSocialMediaReactionsChannel.
        :type: str
        """
        if isinstance(platform, int):
            platform = str(platform)
        allowed_values = ["Open"]
        if platform.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for platform -> " + platform)
            self._platform = "outdated_sdk_version"
        else:
            self._platform = platform

    @property
    def type(self) -> str:
        """
        Gets the type of this OpenSocialMediaReactionsChannel.
        Specifies if this message is part of a private or public conversation.

        :return: The type of this OpenSocialMediaReactionsChannel.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this OpenSocialMediaReactionsChannel.
        Specifies if this message is part of a private or public conversation.

        :param type: The type of this OpenSocialMediaReactionsChannel.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Public"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def message_id(self) -> str:
        """
        Gets the message_id of this OpenSocialMediaReactionsChannel.
        Unique provider ID of the message such as a Open message ID.

        :return: The message_id of this OpenSocialMediaReactionsChannel.
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id: str) -> None:
        """
        Sets the message_id of this OpenSocialMediaReactionsChannel.
        Unique provider ID of the message such as a Open message ID.

        :param message_id: The message_id of this OpenSocialMediaReactionsChannel.
        :type: str
        """
        

        self._message_id = message_id

    @property
    def to(self) -> 'OpenSocialMediaRecipient':
        """
        Gets the to of this OpenSocialMediaReactionsChannel.
        Information about the recipient the message is sent to.

        :return: The to of this OpenSocialMediaReactionsChannel.
        :rtype: OpenSocialMediaRecipient
        """
        return self._to

    @to.setter
    def to(self, to: 'OpenSocialMediaRecipient') -> None:
        """
        Sets the to of this OpenSocialMediaReactionsChannel.
        Information about the recipient the message is sent to.

        :param to: The to of this OpenSocialMediaReactionsChannel.
        :type: OpenSocialMediaRecipient
        """
        

        self._to = to

    @property
    def time(self) -> datetime:
        """
        Gets the time of this OpenSocialMediaReactionsChannel.
        Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The time of this OpenSocialMediaReactionsChannel.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time: datetime) -> None:
        """
        Sets the time of this OpenSocialMediaReactionsChannel.
        Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param time: The time of this OpenSocialMediaReactionsChannel.
        :type: datetime
        """
        

        self._time = time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

