# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenSocialMediaRecipientAdditionalIdentifier

class OpenSocialMediaRecipient(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenSocialMediaRecipient - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'id_type': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'nickname': 'str',
            'image': 'str',
            'additional_ids': 'list[OpenSocialMediaRecipientAdditionalIdentifier]'
        }

        self.attribute_map = {
            'id': 'id',
            'id_type': 'idType',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'nickname': 'nickname',
            'image': 'image',
            'additional_ids': 'additionalIds'
        }

        self._id = None
        self._id_type = None
        self._first_name = None
        self._last_name = None
        self._nickname = None
        self._image = None
        self._additional_ids = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenSocialMediaRecipient.
        The recipient ID specific to the provider.

        :return: The id of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenSocialMediaRecipient.
        The recipient ID specific to the provider.

        :param id: The id of this OpenSocialMediaRecipient.
        :type: str
        """
        

        self._id = id

    @property
    def id_type(self) -> str:
        """
        Gets the id_type of this OpenSocialMediaRecipient.
        The recipient ID type. This is used to indicate the format used for the ID.

        :return: The id_type of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._id_type

    @id_type.setter
    def id_type(self, id_type: str) -> None:
        """
        Sets the id_type of this OpenSocialMediaRecipient.
        The recipient ID type. This is used to indicate the format used for the ID.

        :param id_type: The id_type of this OpenSocialMediaRecipient.
        :type: str
        """
        if isinstance(id_type, int):
            id_type = str(id_type)
        allowed_values = ["Email", "Phone", "Opaque", "Topic"]
        if id_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for id_type -> " + id_type)
            self._id_type = "outdated_sdk_version"
        else:
            self._id_type = id_type

    @property
    def first_name(self) -> str:
        """
        Gets the first_name of this OpenSocialMediaRecipient.
        First name of the recipient.

        :return: The first_name of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name: str) -> None:
        """
        Sets the first_name of this OpenSocialMediaRecipient.
        First name of the recipient.

        :param first_name: The first_name of this OpenSocialMediaRecipient.
        :type: str
        """
        

        self._first_name = first_name

    @property
    def last_name(self) -> str:
        """
        Gets the last_name of this OpenSocialMediaRecipient.
        Last name of the recipient.

        :return: The last_name of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name: str) -> None:
        """
        Sets the last_name of this OpenSocialMediaRecipient.
        Last name of the recipient.

        :param last_name: The last_name of this OpenSocialMediaRecipient.
        :type: str
        """
        

        self._last_name = last_name

    @property
    def nickname(self) -> str:
        """
        Gets the nickname of this OpenSocialMediaRecipient.
        Nickname or display name of the recipient.

        :return: The nickname of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._nickname

    @nickname.setter
    def nickname(self, nickname: str) -> None:
        """
        Sets the nickname of this OpenSocialMediaRecipient.
        Nickname or display name of the recipient.

        :param nickname: The nickname of this OpenSocialMediaRecipient.
        :type: str
        """
        

        self._nickname = nickname

    @property
    def image(self) -> str:
        """
        Gets the image of this OpenSocialMediaRecipient.
        URL of an image that represents the recipient.

        :return: The image of this OpenSocialMediaRecipient.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image: str) -> None:
        """
        Sets the image of this OpenSocialMediaRecipient.
        URL of an image that represents the recipient.

        :param image: The image of this OpenSocialMediaRecipient.
        :type: str
        """
        

        self._image = image

    @property
    def additional_ids(self) -> List['OpenSocialMediaRecipientAdditionalIdentifier']:
        """
        Gets the additional_ids of this OpenSocialMediaRecipient.
        List of recipient additional identifiers

        :return: The additional_ids of this OpenSocialMediaRecipient.
        :rtype: list[OpenSocialMediaRecipientAdditionalIdentifier]
        """
        return self._additional_ids

    @additional_ids.setter
    def additional_ids(self, additional_ids: List['OpenSocialMediaRecipientAdditionalIdentifier']) -> None:
        """
        Sets the additional_ids of this OpenSocialMediaRecipient.
        List of recipient additional identifiers

        :param additional_ids: The additional_ids of this OpenSocialMediaRecipient.
        :type: list[OpenSocialMediaRecipientAdditionalIdentifier]
        """
        

        self._additional_ids = additional_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

