# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenInboundStructuredResponseNormalizedMessageContent
    from . import OpenMessagingChannel

class OpenStructuredResponseNormalizedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenStructuredResponseNormalizedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'channel': 'OpenMessagingChannel',
            'type': 'str',
            'direction': 'str',
            'content': 'list[OpenInboundStructuredResponseNormalizedMessageContent]',
            'metadata': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'channel': 'channel',
            'type': 'type',
            'direction': 'direction',
            'content': 'content',
            'metadata': 'metadata'
        }

        self._id = None
        self._channel = None
        self._type = None
        self._direction = None
        self._content = None
        self._metadata = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenStructuredResponseNormalizedMessage.
        Unique ID of the message. This ID is generated by Messaging Platform. Message receipts will have the same ID as the message they reference, as such should only be set when sending a message receipt.

        :return: The id of this OpenStructuredResponseNormalizedMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenStructuredResponseNormalizedMessage.
        Unique ID of the message. This ID is generated by Messaging Platform. Message receipts will have the same ID as the message they reference, as such should only be set when sending a message receipt.

        :param id: The id of this OpenStructuredResponseNormalizedMessage.
        :type: str
        """
        

        self._id = id

    @property
    def channel(self) -> 'OpenMessagingChannel':
        """
        Gets the channel of this OpenStructuredResponseNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :return: The channel of this OpenStructuredResponseNormalizedMessage.
        :rtype: OpenMessagingChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'OpenMessagingChannel') -> None:
        """
        Sets the channel of this OpenStructuredResponseNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :param channel: The channel of this OpenStructuredResponseNormalizedMessage.
        :type: OpenMessagingChannel
        """
        

        self._channel = channel

    @property
    def type(self) -> str:
        """
        Gets the type of this OpenStructuredResponseNormalizedMessage.
        Message type.

        :return: The type of this OpenStructuredResponseNormalizedMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this OpenStructuredResponseNormalizedMessage.
        Message type.

        :param type: The type of this OpenStructuredResponseNormalizedMessage.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Structured"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def direction(self) -> str:
        """
        Gets the direction of this OpenStructuredResponseNormalizedMessage.
        The direction of the message.

        :return: The direction of this OpenStructuredResponseNormalizedMessage.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this OpenStructuredResponseNormalizedMessage.
        The direction of the message.

        :param direction: The direction of this OpenStructuredResponseNormalizedMessage.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["Inbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def content(self) -> List['OpenInboundStructuredResponseNormalizedMessageContent']:
        """
        Gets the content of this OpenStructuredResponseNormalizedMessage.
        List of content elements.

        :return: The content of this OpenStructuredResponseNormalizedMessage.
        :rtype: list[OpenInboundStructuredResponseNormalizedMessageContent]
        """
        return self._content

    @content.setter
    def content(self, content: List['OpenInboundStructuredResponseNormalizedMessageContent']) -> None:
        """
        Sets the content of this OpenStructuredResponseNormalizedMessage.
        List of content elements.

        :param content: The content of this OpenStructuredResponseNormalizedMessage.
        :type: list[OpenInboundStructuredResponseNormalizedMessageContent]
        """
        

        self._content = content

    @property
    def metadata(self) -> Dict[str, str]:
        """
        Gets the metadata of this OpenStructuredResponseNormalizedMessage.
        Additional metadata about this message.

        :return: The metadata of this OpenStructuredResponseNormalizedMessage.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: Dict[str, str]) -> None:
        """
        Sets the metadata of this OpenStructuredResponseNormalizedMessage.
        Additional metadata about this message.

        :param metadata: The metadata of this OpenStructuredResponseNormalizedMessage.
        :type: dict(str, str)
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

