# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class OrganizationFeatures(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OrganizationFeatures - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'realtime_cic': 'bool',
            'purecloud': 'bool',
            'hipaa': 'bool',
            'uc_enabled': 'bool',
            'pci': 'bool',
            'purecloud_voice': 'bool',
            'xmpp_federation': 'bool',
            'chat': 'bool',
            'informal_photos': 'bool',
            'directory': 'bool',
            'contact_center': 'bool',
            'unified_communications': 'bool',
            'custserv': 'bool'
        }

        self.attribute_map = {
            'realtime_cic': 'realtimeCIC',
            'purecloud': 'purecloud',
            'hipaa': 'hipaa',
            'uc_enabled': 'ucEnabled',
            'pci': 'pci',
            'purecloud_voice': 'purecloudVoice',
            'xmpp_federation': 'xmppFederation',
            'chat': 'chat',
            'informal_photos': 'informalPhotos',
            'directory': 'directory',
            'contact_center': 'contactCenter',
            'unified_communications': 'unifiedCommunications',
            'custserv': 'custserv'
        }

        self._realtime_cic = None
        self._purecloud = None
        self._hipaa = None
        self._uc_enabled = None
        self._pci = None
        self._purecloud_voice = None
        self._xmpp_federation = None
        self._chat = None
        self._informal_photos = None
        self._directory = None
        self._contact_center = None
        self._unified_communications = None
        self._custserv = None

    @property
    def realtime_cic(self) -> bool:
        """
        Gets the realtime_cic of this OrganizationFeatures.


        :return: The realtime_cic of this OrganizationFeatures.
        :rtype: bool
        """
        return self._realtime_cic

    @realtime_cic.setter
    def realtime_cic(self, realtime_cic: bool) -> None:
        """
        Sets the realtime_cic of this OrganizationFeatures.


        :param realtime_cic: The realtime_cic of this OrganizationFeatures.
        :type: bool
        """
        

        self._realtime_cic = realtime_cic

    @property
    def purecloud(self) -> bool:
        """
        Gets the purecloud of this OrganizationFeatures.


        :return: The purecloud of this OrganizationFeatures.
        :rtype: bool
        """
        return self._purecloud

    @purecloud.setter
    def purecloud(self, purecloud: bool) -> None:
        """
        Sets the purecloud of this OrganizationFeatures.


        :param purecloud: The purecloud of this OrganizationFeatures.
        :type: bool
        """
        

        self._purecloud = purecloud

    @property
    def hipaa(self) -> bool:
        """
        Gets the hipaa of this OrganizationFeatures.


        :return: The hipaa of this OrganizationFeatures.
        :rtype: bool
        """
        return self._hipaa

    @hipaa.setter
    def hipaa(self, hipaa: bool) -> None:
        """
        Sets the hipaa of this OrganizationFeatures.


        :param hipaa: The hipaa of this OrganizationFeatures.
        :type: bool
        """
        

        self._hipaa = hipaa

    @property
    def uc_enabled(self) -> bool:
        """
        Gets the uc_enabled of this OrganizationFeatures.


        :return: The uc_enabled of this OrganizationFeatures.
        :rtype: bool
        """
        return self._uc_enabled

    @uc_enabled.setter
    def uc_enabled(self, uc_enabled: bool) -> None:
        """
        Sets the uc_enabled of this OrganizationFeatures.


        :param uc_enabled: The uc_enabled of this OrganizationFeatures.
        :type: bool
        """
        

        self._uc_enabled = uc_enabled

    @property
    def pci(self) -> bool:
        """
        Gets the pci of this OrganizationFeatures.


        :return: The pci of this OrganizationFeatures.
        :rtype: bool
        """
        return self._pci

    @pci.setter
    def pci(self, pci: bool) -> None:
        """
        Sets the pci of this OrganizationFeatures.


        :param pci: The pci of this OrganizationFeatures.
        :type: bool
        """
        

        self._pci = pci

    @property
    def purecloud_voice(self) -> bool:
        """
        Gets the purecloud_voice of this OrganizationFeatures.


        :return: The purecloud_voice of this OrganizationFeatures.
        :rtype: bool
        """
        return self._purecloud_voice

    @purecloud_voice.setter
    def purecloud_voice(self, purecloud_voice: bool) -> None:
        """
        Sets the purecloud_voice of this OrganizationFeatures.


        :param purecloud_voice: The purecloud_voice of this OrganizationFeatures.
        :type: bool
        """
        

        self._purecloud_voice = purecloud_voice

    @property
    def xmpp_federation(self) -> bool:
        """
        Gets the xmpp_federation of this OrganizationFeatures.


        :return: The xmpp_federation of this OrganizationFeatures.
        :rtype: bool
        """
        return self._xmpp_federation

    @xmpp_federation.setter
    def xmpp_federation(self, xmpp_federation: bool) -> None:
        """
        Sets the xmpp_federation of this OrganizationFeatures.


        :param xmpp_federation: The xmpp_federation of this OrganizationFeatures.
        :type: bool
        """
        

        self._xmpp_federation = xmpp_federation

    @property
    def chat(self) -> bool:
        """
        Gets the chat of this OrganizationFeatures.


        :return: The chat of this OrganizationFeatures.
        :rtype: bool
        """
        return self._chat

    @chat.setter
    def chat(self, chat: bool) -> None:
        """
        Sets the chat of this OrganizationFeatures.


        :param chat: The chat of this OrganizationFeatures.
        :type: bool
        """
        

        self._chat = chat

    @property
    def informal_photos(self) -> bool:
        """
        Gets the informal_photos of this OrganizationFeatures.


        :return: The informal_photos of this OrganizationFeatures.
        :rtype: bool
        """
        return self._informal_photos

    @informal_photos.setter
    def informal_photos(self, informal_photos: bool) -> None:
        """
        Sets the informal_photos of this OrganizationFeatures.


        :param informal_photos: The informal_photos of this OrganizationFeatures.
        :type: bool
        """
        

        self._informal_photos = informal_photos

    @property
    def directory(self) -> bool:
        """
        Gets the directory of this OrganizationFeatures.


        :return: The directory of this OrganizationFeatures.
        :rtype: bool
        """
        return self._directory

    @directory.setter
    def directory(self, directory: bool) -> None:
        """
        Sets the directory of this OrganizationFeatures.


        :param directory: The directory of this OrganizationFeatures.
        :type: bool
        """
        

        self._directory = directory

    @property
    def contact_center(self) -> bool:
        """
        Gets the contact_center of this OrganizationFeatures.


        :return: The contact_center of this OrganizationFeatures.
        :rtype: bool
        """
        return self._contact_center

    @contact_center.setter
    def contact_center(self, contact_center: bool) -> None:
        """
        Sets the contact_center of this OrganizationFeatures.


        :param contact_center: The contact_center of this OrganizationFeatures.
        :type: bool
        """
        

        self._contact_center = contact_center

    @property
    def unified_communications(self) -> bool:
        """
        Gets the unified_communications of this OrganizationFeatures.


        :return: The unified_communications of this OrganizationFeatures.
        :rtype: bool
        """
        return self._unified_communications

    @unified_communications.setter
    def unified_communications(self, unified_communications: bool) -> None:
        """
        Sets the unified_communications of this OrganizationFeatures.


        :param unified_communications: The unified_communications of this OrganizationFeatures.
        :type: bool
        """
        

        self._unified_communications = unified_communications

    @property
    def custserv(self) -> bool:
        """
        Gets the custserv of this OrganizationFeatures.


        :return: The custserv of this OrganizationFeatures.
        :rtype: bool
        """
        return self._custserv

    @custserv.setter
    def custserv(self, custserv: bool) -> None:
        """
        Sets the custserv of this OrganizationFeatures.


        :param custserv: The custserv of this OrganizationFeatures.
        :type: bool
        """
        

        self._custserv = custserv

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

