# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import UserReference

class OrganizationPublicApiUsage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OrganizationPublicApiUsage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date': 'date',
            'platform': 'str',
            'http_method': 'str',
            'template_uri': 'str',
            'request_count': 'int',
            'status200': 'int',
            'status300': 'int',
            'status400': 'int',
            'status429': 'int',
            'status500': 'int',
            'oauth_client': 'DomainEntityRef',
            'user': 'UserReference'
        }

        self.attribute_map = {
            'date': 'date',
            'platform': 'platform',
            'http_method': 'httpMethod',
            'template_uri': 'templateUri',
            'request_count': 'requestCount',
            'status200': 'status200',
            'status300': 'status300',
            'status400': 'status400',
            'status429': 'status429',
            'status500': 'status500',
            'oauth_client': 'oauthClient',
            'user': 'user'
        }

        self._date = None
        self._platform = None
        self._http_method = None
        self._template_uri = None
        self._request_count = None
        self._status200 = None
        self._status300 = None
        self._status400 = None
        self._status429 = None
        self._status500 = None
        self._oauth_client = None
        self._user = None

    @property
    def date(self) -> date:
        """
        Gets the date of this OrganizationPublicApiUsage.
        The date of the usage. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date of this OrganizationPublicApiUsage.
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date: date) -> None:
        """
        Sets the date of this OrganizationPublicApiUsage.
        The date of the usage. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date: The date of this OrganizationPublicApiUsage.
        :type: date
        """
        

        self._date = date

    @property
    def platform(self) -> str:
        """
        Gets the platform of this OrganizationPublicApiUsage.
        The platform the request(s) is/were made on.

        :return: The platform of this OrganizationPublicApiUsage.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform: str) -> None:
        """
        Sets the platform of this OrganizationPublicApiUsage.
        The platform the request(s) is/were made on.

        :param platform: The platform of this OrganizationPublicApiUsage.
        :type: str
        """
        

        self._platform = platform

    @property
    def http_method(self) -> str:
        """
        Gets the http_method of this OrganizationPublicApiUsage.
        The http method of the request(s)

        :return: The http_method of this OrganizationPublicApiUsage.
        :rtype: str
        """
        return self._http_method

    @http_method.setter
    def http_method(self, http_method: str) -> None:
        """
        Sets the http_method of this OrganizationPublicApiUsage.
        The http method of the request(s)

        :param http_method: The http_method of this OrganizationPublicApiUsage.
        :type: str
        """
        if isinstance(http_method, int):
            http_method = str(http_method)
        allowed_values = ["GET", "POST", "PUT", "PATCH", "DELETE", "HEAD"]
        if http_method.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for http_method -> " + http_method)
            self._http_method = "outdated_sdk_version"
        else:
            self._http_method = http_method

    @property
    def template_uri(self) -> str:
        """
        Gets the template_uri of this OrganizationPublicApiUsage.
        The templateUri of the request(s).

        :return: The template_uri of this OrganizationPublicApiUsage.
        :rtype: str
        """
        return self._template_uri

    @template_uri.setter
    def template_uri(self, template_uri: str) -> None:
        """
        Sets the template_uri of this OrganizationPublicApiUsage.
        The templateUri of the request(s).

        :param template_uri: The template_uri of this OrganizationPublicApiUsage.
        :type: str
        """
        

        self._template_uri = template_uri

    @property
    def request_count(self) -> int:
        """
        Gets the request_count of this OrganizationPublicApiUsage.
        The total number of requests.

        :return: The request_count of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._request_count

    @request_count.setter
    def request_count(self, request_count: int) -> None:
        """
        Sets the request_count of this OrganizationPublicApiUsage.
        The total number of requests.

        :param request_count: The request_count of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._request_count = request_count

    @property
    def status200(self) -> int:
        """
        Gets the status200 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 2xx HTTP status code.

        :return: The status200 of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._status200

    @status200.setter
    def status200(self, status200: int) -> None:
        """
        Sets the status200 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 2xx HTTP status code.

        :param status200: The status200 of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._status200 = status200

    @property
    def status300(self) -> int:
        """
        Gets the status300 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 3xx HTTP status code.

        :return: The status300 of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._status300

    @status300.setter
    def status300(self, status300: int) -> None:
        """
        Sets the status300 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 3xx HTTP status code.

        :param status300: The status300 of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._status300 = status300

    @property
    def status400(self) -> int:
        """
        Gets the status400 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 4xx HTTP status code.

        :return: The status400 of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._status400

    @status400.setter
    def status400(self, status400: int) -> None:
        """
        Sets the status400 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 4xx HTTP status code.

        :param status400: The status400 of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._status400 = status400

    @property
    def status429(self) -> int:
        """
        Gets the status429 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 429 HTTP status code.

        :return: The status429 of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._status429

    @status429.setter
    def status429(self, status429: int) -> None:
        """
        Sets the status429 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 429 HTTP status code.

        :param status429: The status429 of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._status429 = status429

    @property
    def status500(self) -> int:
        """
        Gets the status500 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 5xx HTTP status code.

        :return: The status500 of this OrganizationPublicApiUsage.
        :rtype: int
        """
        return self._status500

    @status500.setter
    def status500(self, status500: int) -> None:
        """
        Sets the status500 of this OrganizationPublicApiUsage.
        The number of requests resulting in a 5xx HTTP status code.

        :param status500: The status500 of this OrganizationPublicApiUsage.
        :type: int
        """
        

        self._status500 = status500

    @property
    def oauth_client(self) -> 'DomainEntityRef':
        """
        Gets the oauth_client of this OrganizationPublicApiUsage.
        The id of the oauthClient that made the request(s).

        :return: The oauth_client of this OrganizationPublicApiUsage.
        :rtype: DomainEntityRef
        """
        return self._oauth_client

    @oauth_client.setter
    def oauth_client(self, oauth_client: 'DomainEntityRef') -> None:
        """
        Sets the oauth_client of this OrganizationPublicApiUsage.
        The id of the oauthClient that made the request(s).

        :param oauth_client: The oauth_client of this OrganizationPublicApiUsage.
        :type: DomainEntityRef
        """
        

        self._oauth_client = oauth_client

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this OrganizationPublicApiUsage.
        The id of the user who made the request(s).

        :return: The user of this OrganizationPublicApiUsage.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this OrganizationPublicApiUsage.
        The id of the user who made the request(s).

        :param user: The user of this OrganizationPublicApiUsage.
        :type: UserReference
        """
        

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

