# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UsageQuerySortBy

class OrganizationPublicApiUsageQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OrganizationPublicApiUsageQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'granularity': 'str',
            'sort_by': 'list[UsageQuerySortBy]',
            'metrics': 'list[str]',
            'template_uris': 'list[str]',
            'http_methods': 'list[str]',
            'platforms': 'list[str]',
            'group_by': 'list[str]',
            'user_ids': 'list[str]',
            'oauth_client_ids': 'list[str]'
        }

        self.attribute_map = {
            'interval': 'interval',
            'granularity': 'granularity',
            'sort_by': 'sortBy',
            'metrics': 'metrics',
            'template_uris': 'templateUris',
            'http_methods': 'httpMethods',
            'platforms': 'platforms',
            'group_by': 'groupBy',
            'user_ids': 'userIds',
            'oauth_client_ids': 'oauthClientIds'
        }

        self._interval = None
        self._granularity = None
        self._sort_by = None
        self._metrics = None
        self._template_uris = None
        self._http_methods = None
        self._platforms = None
        self._group_by = None
        self._user_ids = None
        self._oauth_client_ids = None

    @property
    def interval(self) -> str:
        """
        Gets the interval of this OrganizationPublicApiUsageQueryRequest.
        Specify the interval to query on. Start and end are inclusive. Start date cannot be more than a year ago. End date cannot be more than 90 days after the start. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this OrganizationPublicApiUsageQueryRequest.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this OrganizationPublicApiUsageQueryRequest.
        Specify the interval to query on. Start and end are inclusive. Start date cannot be more than a year ago. End date cannot be more than 90 days after the start. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this OrganizationPublicApiUsageQueryRequest.
        :type: str
        """
        

        self._interval = interval

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this OrganizationPublicApiUsageQueryRequest.
        Specify the granularity to aggregate the data to.

        :return: The granularity of this OrganizationPublicApiUsageQueryRequest.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this OrganizationPublicApiUsageQueryRequest.
        Specify the granularity to aggregate the data to.

        :param granularity: The granularity of this OrganizationPublicApiUsageQueryRequest.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Day", "Week", "Month"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def sort_by(self) -> List['UsageQuerySortBy']:
        """
        Gets the sort_by of this OrganizationPublicApiUsageQueryRequest.
        Specify how to sort the returned data.

        :return: The sort_by of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[UsageQuerySortBy]
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by: List['UsageQuerySortBy']) -> None:
        """
        Sets the sort_by of this OrganizationPublicApiUsageQueryRequest.
        Specify how to sort the returned data.

        :param sort_by: The sort_by of this OrganizationPublicApiUsageQueryRequest.
        :type: list[UsageQuerySortBy]
        """
        

        self._sort_by = sort_by

    @property
    def metrics(self) -> List[str]:
        """
        Gets the metrics of this OrganizationPublicApiUsageQueryRequest.
        Specify which metrics you want returned (all will be returned by default).

        :return: The metrics of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List[str]) -> None:
        """
        Sets the metrics of this OrganizationPublicApiUsageQueryRequest.
        Specify which metrics you want returned (all will be returned by default).

        :param metrics: The metrics of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._metrics = metrics

    @property
    def template_uris(self) -> List[str]:
        """
        Gets the template_uris of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of templateUris represented in the query.

        :return: The template_uris of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._template_uris

    @template_uris.setter
    def template_uris(self, template_uris: List[str]) -> None:
        """
        Sets the template_uris of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of templateUris represented in the query.

        :param template_uris: The template_uris of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._template_uris = template_uris

    @property
    def http_methods(self) -> List[str]:
        """
        Gets the http_methods of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of httpMethods represented in the query.

        :return: The http_methods of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._http_methods

    @http_methods.setter
    def http_methods(self, http_methods: List[str]) -> None:
        """
        Sets the http_methods of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of httpMethods represented in the query.

        :param http_methods: The http_methods of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._http_methods = http_methods

    @property
    def platforms(self) -> List[str]:
        """
        Gets the platforms of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of platforms represented in the query.

        :return: The platforms of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._platforms

    @platforms.setter
    def platforms(self, platforms: List[str]) -> None:
        """
        Sets the platforms of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of platforms represented in the query.

        :param platforms: The platforms of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._platforms = platforms

    @property
    def group_by(self) -> List[str]:
        """
        Gets the group_by of this OrganizationPublicApiUsageQueryRequest.
        Specify how to aggregate the data (by default the data is not aggregated).

        :return: The group_by of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by: List[str]) -> None:
        """
        Sets the group_by of this OrganizationPublicApiUsageQueryRequest.
        Specify how to aggregate the data (by default the data is not aggregated).

        :param group_by: The group_by of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._group_by = group_by

    @property
    def user_ids(self) -> List[str]:
        """
        Gets the user_ids of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of userIds represented in the query.

        :return: The user_ids of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._user_ids

    @user_ids.setter
    def user_ids(self, user_ids: List[str]) -> None:
        """
        Sets the user_ids of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of userIds represented in the query.

        :param user_ids: The user_ids of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._user_ids = user_ids

    @property
    def oauth_client_ids(self) -> List[str]:
        """
        Gets the oauth_client_ids of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of oauthClientIds represented in the query.

        :return: The oauth_client_ids of this OrganizationPublicApiUsageQueryRequest.
        :rtype: list[str]
        """
        return self._oauth_client_ids

    @oauth_client_ids.setter
    def oauth_client_ids(self, oauth_client_ids: List[str]) -> None:
        """
        Sets the oauth_client_ids of this OrganizationPublicApiUsageQueryRequest.
        Specify if you only want a subset of oauthClientIds represented in the query.

        :param oauth_client_ids: The oauth_client_ids of this OrganizationPublicApiUsageQueryRequest.
        :type: list[str]
        """
        

        self._oauth_client_ids = oauth_client_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

