# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes

class OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_time': 'int',
            'outbound_campaign_type': 'str',
            'email_attributes': 'OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes',
            'wrapup_code': 'str',
            'outbound_campaign_id': 'str',
            'division_id': 'str',
            'content_template_id': 'str',
            'outbound_contact_list_id': 'str',
            'outbound_contact_id': 'str',
            'is_campaign_always_running': 'bool'
        }

        self.attribute_map = {
            'event_time': 'eventTime',
            'outbound_campaign_type': 'outboundCampaignType',
            'email_attributes': 'emailAttributes',
            'wrapup_code': 'wrapupCode',
            'outbound_campaign_id': 'outboundCampaignId',
            'division_id': 'divisionId',
            'content_template_id': 'contentTemplateId',
            'outbound_contact_list_id': 'outboundContactListId',
            'outbound_contact_id': 'outboundContactId',
            'is_campaign_always_running': 'isCampaignAlwaysRunning'
        }

        self._event_time = None
        self._outbound_campaign_type = None
        self._email_attributes = None
        self._wrapup_code = None
        self._outbound_campaign_id = None
        self._division_id = None
        self._content_template_id = None
        self._outbound_contact_list_id = None
        self._outbound_contact_id = None
        self._is_campaign_always_running = None

    @property
    def event_time(self) -> int:
        """
        Gets the event_time of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The event_time of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: int
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time: int) -> None:
        """
        Sets the event_time of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param event_time: The event_time of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: int
        """
        

        self._event_time = event_time

    @property
    def outbound_campaign_type(self) -> str:
        """
        Gets the outbound_campaign_type of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The outbound_campaign_type of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._outbound_campaign_type

    @outbound_campaign_type.setter
    def outbound_campaign_type(self, outbound_campaign_type: str) -> None:
        """
        Sets the outbound_campaign_type of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param outbound_campaign_type: The outbound_campaign_type of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        if isinstance(outbound_campaign_type, int):
            outbound_campaign_type = str(outbound_campaign_type)
        allowed_values = ["UNKNOWN", "EMAIL", "SMS", "WHATSAPP"]
        if outbound_campaign_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for outbound_campaign_type -> " + outbound_campaign_type)
            self._outbound_campaign_type = "outdated_sdk_version"
        else:
            self._outbound_campaign_type = outbound_campaign_type

    @property
    def email_attributes(self) -> 'OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes':
        """
        Gets the email_attributes of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The email_attributes of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes
        """
        return self._email_attributes

    @email_attributes.setter
    def email_attributes(self, email_attributes: 'OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes') -> None:
        """
        Sets the email_attributes of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param email_attributes: The email_attributes of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: OutboundMessagingCampaignPreContactEmailEventTopicEmailAttributes
        """
        

        self._email_attributes = email_attributes

    @property
    def wrapup_code(self) -> str:
        """
        Gets the wrapup_code of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The wrapup_code of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._wrapup_code

    @wrapup_code.setter
    def wrapup_code(self, wrapup_code: str) -> None:
        """
        Sets the wrapup_code of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param wrapup_code: The wrapup_code of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        if isinstance(wrapup_code, int):
            wrapup_code = str(wrapup_code)
        allowed_values = ["UNKNOWN", "OUTBOUND_EMAILS_INVALID_SKIPPED", "OUTBOUND_INVALID_EMAIL_ADDRESS", "OUTBOUND_MAX_EMAIL_SUBJECT_LENGTH_EXCEEDED", "OUTBOUND_MAX_EMAIL_BODY_LENGTH_EXCEEDED", "OUTBOUND_RULE_ERROR_SKIPPED", "OUTBOUND_RULE_SKIPPED", "OUTBOUND_CONTACT_UNCONTACTABLE_SKIPPED", "OUTBOUND_NUMBER_UNCONTACTABLE_SKIPPED", "OUTBOUND_CONTACT_ADDRESS_UNCONTACTABLE_SKIPPED", "ININ_OUTBOUND_ZONE_BLOCKED_SKIPPED", "ININ_OUTBOUND_DNC_SKIPPED", "ININ_OUTBOUND_INTERNAL_ERROR_SKIPPED", "ININ_OUTBOUND_ON_DO_NOT_CALL_LIST", "ININ_OUTBOUND_NOT_CALLABLE_TIME", "OUTBOUND_STUCK_CONTACT"]
        if wrapup_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for wrapup_code -> " + wrapup_code)
            self._wrapup_code = "outdated_sdk_version"
        else:
            self._wrapup_code = wrapup_code

    @property
    def outbound_campaign_id(self) -> str:
        """
        Gets the outbound_campaign_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The outbound_campaign_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._outbound_campaign_id

    @outbound_campaign_id.setter
    def outbound_campaign_id(self, outbound_campaign_id: str) -> None:
        """
        Sets the outbound_campaign_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param outbound_campaign_id: The outbound_campaign_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        

        self._outbound_campaign_id = outbound_campaign_id

    @property
    def division_id(self) -> str:
        """
        Gets the division_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The division_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id: str) -> None:
        """
        Sets the division_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param division_id: The division_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def content_template_id(self) -> str:
        """
        Gets the content_template_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The content_template_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._content_template_id

    @content_template_id.setter
    def content_template_id(self, content_template_id: str) -> None:
        """
        Sets the content_template_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param content_template_id: The content_template_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        

        self._content_template_id = content_template_id

    @property
    def outbound_contact_list_id(self) -> str:
        """
        Gets the outbound_contact_list_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The outbound_contact_list_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._outbound_contact_list_id

    @outbound_contact_list_id.setter
    def outbound_contact_list_id(self, outbound_contact_list_id: str) -> None:
        """
        Sets the outbound_contact_list_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param outbound_contact_list_id: The outbound_contact_list_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        

        self._outbound_contact_list_id = outbound_contact_list_id

    @property
    def outbound_contact_id(self) -> str:
        """
        Gets the outbound_contact_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The outbound_contact_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: str
        """
        return self._outbound_contact_id

    @outbound_contact_id.setter
    def outbound_contact_id(self, outbound_contact_id: str) -> None:
        """
        Sets the outbound_contact_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param outbound_contact_id: The outbound_contact_id of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: str
        """
        

        self._outbound_contact_id = outbound_contact_id

    @property
    def is_campaign_always_running(self) -> bool:
        """
        Gets the is_campaign_always_running of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :return: The is_campaign_always_running of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :rtype: bool
        """
        return self._is_campaign_always_running

    @is_campaign_always_running.setter
    def is_campaign_always_running(self, is_campaign_always_running: bool) -> None:
        """
        Sets the is_campaign_always_running of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.


        :param is_campaign_always_running: The is_campaign_always_running of this OutboundMessagingCampaignPreContactEmailEventTopicOutboundMessagingCampaignPreContactEmailEvent.
        :type: bool
        """
        

        self._is_campaign_always_running = is_campaign_always_running

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

