# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingEmailCampaignConfigChangeContactSort
    from . import OutboundMessagingEmailCampaignConfigChangeEmailConfig
    from . import OutboundMessagingEmailCampaignConfigChangeErrorDetail
    from . import OutboundMessagingEmailCampaignConfigChangeSmsConfig
    from . import OutboundMessagingEmailCampaignConfigChangeUriReference
    from . import OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig

class OutboundMessagingEmailCampaignConfigChangeMessagingCampaign(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingEmailCampaignConfigChangeMessagingCampaign - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign_status': 'str',
            'callable_time_set': 'OutboundMessagingEmailCampaignConfigChangeUriReference',
            'contact_list': 'OutboundMessagingEmailCampaignConfigChangeUriReference',
            'dnc_lists': 'list[OutboundMessagingEmailCampaignConfigChangeUriReference]',
            'contact_list_filters': 'list[OutboundMessagingEmailCampaignConfigChangeUriReference]',
            'always_running': 'bool',
            'contact_sorts': 'list[OutboundMessagingEmailCampaignConfigChangeContactSort]',
            'messages_per_minute': 'int',
            'rule_sets': 'list[OutboundMessagingEmailCampaignConfigChangeUriReference]',
            'sms_config': 'OutboundMessagingEmailCampaignConfigChangeSmsConfig',
            'email_config': 'OutboundMessagingEmailCampaignConfigChangeEmailConfig',
            'whats_app_config': 'OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig',
            'errors': 'list[OutboundMessagingEmailCampaignConfigChangeErrorDetail]',
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'division': 'OutboundMessagingEmailCampaignConfigChangeUriReference'
        }

        self.attribute_map = {
            'campaign_status': 'campaignStatus',
            'callable_time_set': 'callableTimeSet',
            'contact_list': 'contactList',
            'dnc_lists': 'dncLists',
            'contact_list_filters': 'contactListFilters',
            'always_running': 'alwaysRunning',
            'contact_sorts': 'contactSorts',
            'messages_per_minute': 'messagesPerMinute',
            'rule_sets': 'ruleSets',
            'sms_config': 'smsConfig',
            'email_config': 'emailConfig',
            'whats_app_config': 'whatsAppConfig',
            'errors': 'errors',
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'division': 'division'
        }

        self._campaign_status = None
        self._callable_time_set = None
        self._contact_list = None
        self._dnc_lists = None
        self._contact_list_filters = None
        self._always_running = None
        self._contact_sorts = None
        self._messages_per_minute = None
        self._rule_sets = None
        self._sms_config = None
        self._email_config = None
        self._whats_app_config = None
        self._errors = None
        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._division = None

    @property
    def campaign_status(self) -> str:
        """
        Gets the campaign_status of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The campaign_status of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._campaign_status

    @campaign_status.setter
    def campaign_status(self, campaign_status: str) -> None:
        """
        Sets the campaign_status of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param campaign_status: The campaign_status of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        if isinstance(campaign_status, int):
            campaign_status = str(campaign_status)
        allowed_values = ["on", "off", "complete", "stopping", "invalid", "forced_off", "forced_stopping"]
        if campaign_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for campaign_status -> " + campaign_status)
            self._campaign_status = "outdated_sdk_version"
        else:
            self._campaign_status = campaign_status

    @property
    def callable_time_set(self) -> 'OutboundMessagingEmailCampaignConfigChangeUriReference':
        """
        Gets the callable_time_set of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The callable_time_set of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        return self._callable_time_set

    @callable_time_set.setter
    def callable_time_set(self, callable_time_set: 'OutboundMessagingEmailCampaignConfigChangeUriReference') -> None:
        """
        Sets the callable_time_set of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param callable_time_set: The callable_time_set of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        

        self._callable_time_set = callable_time_set

    @property
    def contact_list(self) -> 'OutboundMessagingEmailCampaignConfigChangeUriReference':
        """
        Gets the contact_list of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :return: The contact_list of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list: 'OutboundMessagingEmailCampaignConfigChangeUriReference') -> None:
        """
        Sets the contact_list of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :param contact_list: The contact_list of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        

        self._contact_list = contact_list

    @property
    def dnc_lists(self) -> List['OutboundMessagingEmailCampaignConfigChangeUriReference']:
        """
        Gets the dnc_lists of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :return: The dnc_lists of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        return self._dnc_lists

    @dnc_lists.setter
    def dnc_lists(self, dnc_lists: List['OutboundMessagingEmailCampaignConfigChangeUriReference']) -> None:
        """
        Sets the dnc_lists of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The dnc lists to check before sending a message for this messaging campaign.

        :param dnc_lists: The dnc_lists of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        

        self._dnc_lists = dnc_lists

    @property
    def contact_list_filters(self) -> List['OutboundMessagingEmailCampaignConfigChangeUriReference']:
        """
        Gets the contact_list_filters of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The contact list filters to check before sending a message for this messaging campaign.

        :return: The contact_list_filters of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        return self._contact_list_filters

    @contact_list_filters.setter
    def contact_list_filters(self, contact_list_filters: List['OutboundMessagingEmailCampaignConfigChangeUriReference']) -> None:
        """
        Sets the contact_list_filters of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The contact list filters to check before sending a message for this messaging campaign.

        :param contact_list_filters: The contact_list_filters of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        

        self._contact_list_filters = contact_list_filters

    @property
    def always_running(self) -> bool:
        """
        Gets the always_running of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Whether this messaging campaign is always running.

        :return: The always_running of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: bool
        """
        return self._always_running

    @always_running.setter
    def always_running(self, always_running: bool) -> None:
        """
        Sets the always_running of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Whether this messaging campaign is always running.

        :param always_running: The always_running of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: bool
        """
        

        self._always_running = always_running

    @property
    def contact_sorts(self) -> List['OutboundMessagingEmailCampaignConfigChangeContactSort']:
        """
        Gets the contact_sorts of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :return: The contact_sorts of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingEmailCampaignConfigChangeContactSort]
        """
        return self._contact_sorts

    @contact_sorts.setter
    def contact_sorts(self, contact_sorts: List['OutboundMessagingEmailCampaignConfigChangeContactSort']) -> None:
        """
        Sets the contact_sorts of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The order in which to sort contacts for dialing, based on up to four columns.

        :param contact_sorts: The contact_sorts of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingEmailCampaignConfigChangeContactSort]
        """
        

        self._contact_sorts = contact_sorts

    @property
    def messages_per_minute(self) -> int:
        """
        Gets the messages_per_minute of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :return: The messages_per_minute of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._messages_per_minute

    @messages_per_minute.setter
    def messages_per_minute(self, messages_per_minute: int) -> None:
        """
        Sets the messages_per_minute of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        How many messages this messaging campaign will send per minute.

        :param messages_per_minute: The messages_per_minute of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        

        self._messages_per_minute = messages_per_minute

    @property
    def rule_sets(self) -> List['OutboundMessagingEmailCampaignConfigChangeUriReference']:
        """
        Gets the rule_sets of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The rule_sets of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        return self._rule_sets

    @rule_sets.setter
    def rule_sets(self, rule_sets: List['OutboundMessagingEmailCampaignConfigChangeUriReference']) -> None:
        """
        Sets the rule_sets of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param rule_sets: The rule_sets of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingEmailCampaignConfigChangeUriReference]
        """
        

        self._rule_sets = rule_sets

    @property
    def sms_config(self) -> 'OutboundMessagingEmailCampaignConfigChangeSmsConfig':
        """
        Gets the sms_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The sms_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeSmsConfig
        """
        return self._sms_config

    @sms_config.setter
    def sms_config(self, sms_config: 'OutboundMessagingEmailCampaignConfigChangeSmsConfig') -> None:
        """
        Sets the sms_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param sms_config: The sms_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeSmsConfig
        """
        

        self._sms_config = sms_config

    @property
    def email_config(self) -> 'OutboundMessagingEmailCampaignConfigChangeEmailConfig':
        """
        Gets the email_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The email_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeEmailConfig
        """
        return self._email_config

    @email_config.setter
    def email_config(self, email_config: 'OutboundMessagingEmailCampaignConfigChangeEmailConfig') -> None:
        """
        Sets the email_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param email_config: The email_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeEmailConfig
        """
        

        self._email_config = email_config

    @property
    def whats_app_config(self) -> 'OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig':
        """
        Gets the whats_app_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :return: The whats_app_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig
        """
        return self._whats_app_config

    @whats_app_config.setter
    def whats_app_config(self, whats_app_config: 'OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig') -> None:
        """
        Sets the whats_app_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.


        :param whats_app_config: The whats_app_config of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeWhatsAppConfig
        """
        

        self._whats_app_config = whats_app_config

    @property
    def errors(self) -> List['OutboundMessagingEmailCampaignConfigChangeErrorDetail']:
        """
        Gets the errors of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A list of current error conditions associated with this messaging campaign

        :return: The errors of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: list[OutboundMessagingEmailCampaignConfigChangeErrorDetail]
        """
        return self._errors

    @errors.setter
    def errors(self, errors: List['OutboundMessagingEmailCampaignConfigChangeErrorDetail']) -> None:
        """
        Sets the errors of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A list of current error conditions associated with this messaging campaign

        :param errors: The errors of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: list[OutboundMessagingEmailCampaignConfigChangeErrorDetail]
        """
        

        self._errors = errors

    @property
    def id(self) -> str:
        """
        Gets the id of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The globally unique identifier for the object.

        :return: The id of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The globally unique identifier for the object.

        :param id: The id of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The UI-visible name of the object

        :return: The name of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        The UI-visible name of the object

        :param name: The name of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Creation time of the entity

        :return: The date_created of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Creation time of the entity

        :param date_created: The date_created of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Last modified time of the entity

        :return: The date_modified of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Last modified time of the entity

        :param date_modified: The date_modified of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :return: The version of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: int
        """
        

        self._version = version

    @property
    def division(self) -> 'OutboundMessagingEmailCampaignConfigChangeUriReference':
        """
        Gets the division of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :return: The division of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :rtype: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        return self._division

    @division.setter
    def division(self, division: 'OutboundMessagingEmailCampaignConfigChangeUriReference') -> None:
        """
        Sets the division of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        A UriReference for a resource

        :param division: The division of this OutboundMessagingEmailCampaignConfigChangeMessagingCampaign.
        :type: OutboundMessagingEmailCampaignConfigChangeUriReference
        """
        

        self._division = division

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

