# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingMessagingCampaignProgressEventUriReference

class OutboundMessagingMessagingCampaignProgressEventCampaignProgress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingMessagingCampaignProgressEventCampaignProgress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign': 'OutboundMessagingMessagingCampaignProgressEventUriReference',
            'number_of_contacts_called': 'float',
            'number_of_contacts_messaged': 'float',
            'total_number_of_contacts': 'float',
            'percentage': 'int',
            'number_of_contacts_skipped': 'dict(str, int)',
            'additional_properties': 'dict(str, object)',
            'get_additional_properties': 'dict(str, object)'
        }

        self.attribute_map = {
            'campaign': 'campaign',
            'number_of_contacts_called': 'numberOfContactsCalled',
            'number_of_contacts_messaged': 'numberOfContactsMessaged',
            'total_number_of_contacts': 'totalNumberOfContacts',
            'percentage': 'percentage',
            'number_of_contacts_skipped': 'numberOfContactsSkipped',
            'additional_properties': 'additionalProperties',
            'get_additional_properties': 'getAdditionalProperties'
        }

        self._campaign = None
        self._number_of_contacts_called = None
        self._number_of_contacts_messaged = None
        self._total_number_of_contacts = None
        self._percentage = None
        self._number_of_contacts_skipped = None
        self._additional_properties = None
        self._get_additional_properties = None

    @property
    def campaign(self) -> 'OutboundMessagingMessagingCampaignProgressEventUriReference':
        """
        Gets the campaign of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :return: The campaign of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: OutboundMessagingMessagingCampaignProgressEventUriReference
        """
        return self._campaign

    @campaign.setter
    def campaign(self, campaign: 'OutboundMessagingMessagingCampaignProgressEventUriReference') -> None:
        """
        Sets the campaign of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :param campaign: The campaign of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: OutboundMessagingMessagingCampaignProgressEventUriReference
        """
        

        self._campaign = campaign

    @property
    def number_of_contacts_called(self) -> float:
        """
        Gets the number_of_contacts_called of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The number of contacts that have been called so far

        :return: The number_of_contacts_called of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: float
        """
        return self._number_of_contacts_called

    @number_of_contacts_called.setter
    def number_of_contacts_called(self, number_of_contacts_called: float) -> None:
        """
        Sets the number_of_contacts_called of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The number of contacts that have been called so far

        :param number_of_contacts_called: The number_of_contacts_called of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: float
        """
        

        self._number_of_contacts_called = number_of_contacts_called

    @property
    def number_of_contacts_messaged(self) -> float:
        """
        Gets the number_of_contacts_messaged of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The number of contacts that have been messaged so far

        :return: The number_of_contacts_messaged of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: float
        """
        return self._number_of_contacts_messaged

    @number_of_contacts_messaged.setter
    def number_of_contacts_messaged(self, number_of_contacts_messaged: float) -> None:
        """
        Sets the number_of_contacts_messaged of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The number of contacts that have been messaged so far

        :param number_of_contacts_messaged: The number_of_contacts_messaged of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: float
        """
        

        self._number_of_contacts_messaged = number_of_contacts_messaged

    @property
    def total_number_of_contacts(self) -> float:
        """
        Gets the total_number_of_contacts of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The total number of contacts in the contact list

        :return: The total_number_of_contacts of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: float
        """
        return self._total_number_of_contacts

    @total_number_of_contacts.setter
    def total_number_of_contacts(self, total_number_of_contacts: float) -> None:
        """
        Sets the total_number_of_contacts of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        The total number of contacts in the contact list

        :param total_number_of_contacts: The total_number_of_contacts of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: float
        """
        

        self._total_number_of_contacts = total_number_of_contacts

    @property
    def percentage(self) -> int:
        """
        Gets the percentage of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        numberOfContactsContacted/totalNumberOfContacts*100

        :return: The percentage of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: int
        """
        return self._percentage

    @percentage.setter
    def percentage(self, percentage: int) -> None:
        """
        Sets the percentage of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        numberOfContactsContacted/totalNumberOfContacts*100

        :param percentage: The percentage of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: int
        """
        

        self._percentage = percentage

    @property
    def number_of_contacts_skipped(self) -> Dict[str, int]:
        """
        Gets the number_of_contacts_skipped of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        A map of skipped reasons and the number of contacts associated with each.

        :return: The number_of_contacts_skipped of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: dict(str, int)
        """
        return self._number_of_contacts_skipped

    @number_of_contacts_skipped.setter
    def number_of_contacts_skipped(self, number_of_contacts_skipped: Dict[str, int]) -> None:
        """
        Sets the number_of_contacts_skipped of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        A map of skipped reasons and the number of contacts associated with each.

        :param number_of_contacts_skipped: The number_of_contacts_skipped of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: dict(str, int)
        """
        

        self._number_of_contacts_skipped = number_of_contacts_skipped

    @property
    def additional_properties(self) -> Dict[str, object]:
        """
        Gets the additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :return: The additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: dict(str, object)
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: Dict[str, object]) -> None:
        """
        Sets the additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :param additional_properties: The additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: dict(str, object)
        """
        

        self._additional_properties = additional_properties

    @property
    def get_additional_properties(self) -> Dict[str, object]:
        """
        Gets the get_additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :return: The get_additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :rtype: dict(str, object)
        """
        return self._get_additional_properties

    @get_additional_properties.setter
    def get_additional_properties(self, get_additional_properties: Dict[str, object]) -> None:
        """
        Sets the get_additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.


        :param get_additional_properties: The get_additional_properties of this OutboundMessagingMessagingCampaignProgressEventCampaignProgress.
        :type: dict(str, object)
        """
        

        self._get_additional_properties = get_additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

