# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class OutcomeQuantileCondition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutcomeQuantileCondition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'outcome_id': 'str',
            'max_quantile_threshold': 'float',
            'fallback_quantile_threshold': 'float'
        }

        self.attribute_map = {
            'outcome_id': 'outcomeId',
            'max_quantile_threshold': 'maxQuantileThreshold',
            'fallback_quantile_threshold': 'fallbackQuantileThreshold'
        }

        self._outcome_id = None
        self._max_quantile_threshold = None
        self._fallback_quantile_threshold = None

    @property
    def outcome_id(self) -> str:
        """
        Gets the outcome_id of this OutcomeQuantileCondition.
        The outcome ID.

        :return: The outcome_id of this OutcomeQuantileCondition.
        :rtype: str
        """
        return self._outcome_id

    @outcome_id.setter
    def outcome_id(self, outcome_id: str) -> None:
        """
        Sets the outcome_id of this OutcomeQuantileCondition.
        The outcome ID.

        :param outcome_id: The outcome_id of this OutcomeQuantileCondition.
        :type: str
        """
        

        self._outcome_id = outcome_id

    @property
    def max_quantile_threshold(self) -> float:
        """
        Gets the max_quantile_threshold of this OutcomeQuantileCondition.
        This Outcome Quantile Condition is met when sessionMaxQuantile of the OutcomeScore is above this value, (unless fallbackQuantile is set). Range 0.00-1.00

        :return: The max_quantile_threshold of this OutcomeQuantileCondition.
        :rtype: float
        """
        return self._max_quantile_threshold

    @max_quantile_threshold.setter
    def max_quantile_threshold(self, max_quantile_threshold: float) -> None:
        """
        Sets the max_quantile_threshold of this OutcomeQuantileCondition.
        This Outcome Quantile Condition is met when sessionMaxQuantile of the OutcomeScore is above this value, (unless fallbackQuantile is set). Range 0.00-1.00

        :param max_quantile_threshold: The max_quantile_threshold of this OutcomeQuantileCondition.
        :type: float
        """
        

        self._max_quantile_threshold = max_quantile_threshold

    @property
    def fallback_quantile_threshold(self) -> float:
        """
        Gets the fallback_quantile_threshold of this OutcomeQuantileCondition.
        (Optional) If set, this Condition is met when maxQuantileThreshold is met, AND the current quantile of the OutcomeScore is below this fallbackQuantileThreshold. Range 0.00-1.00

        :return: The fallback_quantile_threshold of this OutcomeQuantileCondition.
        :rtype: float
        """
        return self._fallback_quantile_threshold

    @fallback_quantile_threshold.setter
    def fallback_quantile_threshold(self, fallback_quantile_threshold: float) -> None:
        """
        Sets the fallback_quantile_threshold of this OutcomeQuantileCondition.
        (Optional) If set, this Condition is met when maxQuantileThreshold is met, AND the current quantile of the OutcomeScore is below this fallbackQuantileThreshold. Range 0.00-1.00

        :param fallback_quantile_threshold: The fallback_quantile_threshold of this OutcomeQuantileCondition.
        :type: float
        """
        

        self._fallback_quantile_threshold = fallback_quantile_threshold

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

