# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class OutcomeScore(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutcomeScore - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'outcome': 'AddressableEntityRef',
            'session_max_probability': 'float',
            'probability': 'float',
            'percentile': 'int',
            'session_max_percentile': 'int',
            'quantile': 'float',
            'session_max_quantile': 'float'
        }

        self.attribute_map = {
            'outcome': 'outcome',
            'session_max_probability': 'sessionMaxProbability',
            'probability': 'probability',
            'percentile': 'percentile',
            'session_max_percentile': 'sessionMaxPercentile',
            'quantile': 'quantile',
            'session_max_quantile': 'sessionMaxQuantile'
        }

        self._outcome = None
        self._session_max_probability = None
        self._probability = None
        self._percentile = None
        self._session_max_percentile = None
        self._quantile = None
        self._session_max_quantile = None

    @property
    def outcome(self) -> 'AddressableEntityRef':
        """
        Gets the outcome of this OutcomeScore.
        The outcome that the score was calculated for.

        :return: The outcome of this OutcomeScore.
        :rtype: AddressableEntityRef
        """
        return self._outcome

    @outcome.setter
    def outcome(self, outcome: 'AddressableEntityRef') -> None:
        """
        Sets the outcome of this OutcomeScore.
        The outcome that the score was calculated for.

        :param outcome: The outcome of this OutcomeScore.
        :type: AddressableEntityRef
        """
        

        self._outcome = outcome

    @property
    def session_max_probability(self) -> float:
        """
        Gets the session_max_probability of this OutcomeScore.
        Represents the max probability reached in the session.

        :return: The session_max_probability of this OutcomeScore.
        :rtype: float
        """
        return self._session_max_probability

    @session_max_probability.setter
    def session_max_probability(self, session_max_probability: float) -> None:
        """
        Sets the session_max_probability of this OutcomeScore.
        Represents the max probability reached in the session.

        :param session_max_probability: The session_max_probability of this OutcomeScore.
        :type: float
        """
        

        self._session_max_probability = session_max_probability

    @property
    def probability(self) -> float:
        """
        Gets the probability of this OutcomeScore.
        Represents the likelihood of a customer reaching or achieving a given outcome.

        :return: The probability of this OutcomeScore.
        :rtype: float
        """
        return self._probability

    @probability.setter
    def probability(self, probability: float) -> None:
        """
        Sets the probability of this OutcomeScore.
        Represents the likelihood of a customer reaching or achieving a given outcome.

        :param probability: The probability of this OutcomeScore.
        :type: float
        """
        

        self._probability = probability

    @property
    def percentile(self) -> int:
        """
        Gets the percentile of this OutcomeScore.
        (Deprecated: use the 'quantile' field instead) Represents the predicted probability's percentile score when compared with all other generated probabilities for a given outcome.

        :return: The percentile of this OutcomeScore.
        :rtype: int
        """
        return self._percentile

    @percentile.setter
    def percentile(self, percentile: int) -> None:
        """
        Sets the percentile of this OutcomeScore.
        (Deprecated: use the 'quantile' field instead) Represents the predicted probability's percentile score when compared with all other generated probabilities for a given outcome.

        :param percentile: The percentile of this OutcomeScore.
        :type: int
        """
        

        self._percentile = percentile

    @property
    def session_max_percentile(self) -> int:
        """
        Gets the session_max_percentile of this OutcomeScore.
        (Deprecated: use the 'quantile' field instead) Represents the maximum likelihood percentile score reached for a given outcome by the current session.

        :return: The session_max_percentile of this OutcomeScore.
        :rtype: int
        """
        return self._session_max_percentile

    @session_max_percentile.setter
    def session_max_percentile(self, session_max_percentile: int) -> None:
        """
        Sets the session_max_percentile of this OutcomeScore.
        (Deprecated: use the 'quantile' field instead) Represents the maximum likelihood percentile score reached for a given outcome by the current session.

        :param session_max_percentile: The session_max_percentile of this OutcomeScore.
        :type: int
        """
        

        self._session_max_percentile = session_max_percentile

    @property
    def quantile(self) -> float:
        """
        Gets the quantile of this OutcomeScore.
        Represents the quantity of sessions that have a maximum probability less than the predicted probability.

        :return: The quantile of this OutcomeScore.
        :rtype: float
        """
        return self._quantile

    @quantile.setter
    def quantile(self, quantile: float) -> None:
        """
        Sets the quantile of this OutcomeScore.
        Represents the quantity of sessions that have a maximum probability less than the predicted probability.

        :param quantile: The quantile of this OutcomeScore.
        :type: float
        """
        

        self._quantile = quantile

    @property
    def session_max_quantile(self) -> float:
        """
        Gets the session_max_quantile of this OutcomeScore.
        Represents the quantity of sessions that have a maximum probability less than the predicted session max probability.

        :return: The session_max_quantile of this OutcomeScore.
        :rtype: float
        """
        return self._session_max_quantile

    @session_max_quantile.setter
    def session_max_quantile(self, session_max_quantile: float) -> None:
        """
        Sets the session_max_quantile of this OutcomeScore.
        Represents the quantity of sessions that have a maximum probability less than the predicted session max probability.

        :param session_max_quantile: The session_max_quantile of this OutcomeScore.
        :type: float
        """
        

        self._session_max_quantile = session_max_quantile

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

