# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BotEntityValue
    from . import ErrorInfo
    from . import ReplyMessage

class OutgoingMessageRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutgoingMessageRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'bot_id': 'str',
            'bot_version': 'str',
            'bot_session_id': 'str',
            'bot_state': 'str',
            'language_code': 'str',
            'reply_messages': 'list[ReplyMessage]',
            'intent': 'str',
            'confidence': 'float',
            'error_info': 'ErrorInfo',
            'parameters': 'dict(str, str)',
            'entities': 'list[BotEntityValue]'
        }

        self.attribute_map = {
            'bot_id': 'botId',
            'bot_version': 'botVersion',
            'bot_session_id': 'botSessionId',
            'bot_state': 'botState',
            'language_code': 'languageCode',
            'reply_messages': 'replyMessages',
            'intent': 'intent',
            'confidence': 'confidence',
            'error_info': 'errorInfo',
            'parameters': 'parameters',
            'entities': 'entities'
        }

        self._bot_id = None
        self._bot_version = None
        self._bot_session_id = None
        self._bot_state = None
        self._language_code = None
        self._reply_messages = None
        self._intent = None
        self._confidence = None
        self._error_info = None
        self._parameters = None
        self._entities = None

    @property
    def bot_id(self) -> str:
        """
        Gets the bot_id of this OutgoingMessageRequest.
        The unique id of the bot.

        :return: The bot_id of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._bot_id

    @bot_id.setter
    def bot_id(self, bot_id: str) -> None:
        """
        Sets the bot_id of this OutgoingMessageRequest.
        The unique id of the bot.

        :param bot_id: The bot_id of this OutgoingMessageRequest.
        :type: str
        """
        

        self._bot_id = bot_id

    @property
    def bot_version(self) -> str:
        """
        Gets the bot_version of this OutgoingMessageRequest.
        The version of the bot.

        :return: The bot_version of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._bot_version

    @bot_version.setter
    def bot_version(self, bot_version: str) -> None:
        """
        Sets the bot_version of this OutgoingMessageRequest.
        The version of the bot.

        :param bot_version: The bot_version of this OutgoingMessageRequest.
        :type: str
        """
        

        self._bot_version = bot_version

    @property
    def bot_session_id(self) -> str:
        """
        Gets the bot_session_id of this OutgoingMessageRequest.
        The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).

        :return: The bot_session_id of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._bot_session_id

    @bot_session_id.setter
    def bot_session_id(self, bot_session_id: str) -> None:
        """
        Sets the bot_session_id of this OutgoingMessageRequest.
        The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).

        :param bot_session_id: The bot_session_id of this OutgoingMessageRequest.
        :type: str
        """
        

        self._bot_session_id = bot_session_id

    @property
    def bot_state(self) -> str:
        """
        Gets the bot_state of this OutgoingMessageRequest.
        The state of the bot reported

        :return: The bot_state of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._bot_state

    @bot_state.setter
    def bot_state(self, bot_state: str) -> None:
        """
        Sets the bot_state of this OutgoingMessageRequest.
        The state of the bot reported

        :param bot_state: The bot_state of this OutgoingMessageRequest.
        :type: str
        """
        if isinstance(bot_state, int):
            bot_state = str(bot_state)
        allowed_values = ["Complete", "Failed", "MoreData"]
        if bot_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for bot_state -> " + bot_state)
            self._bot_state = "outdated_sdk_version"
        else:
            self._bot_state = bot_state

    @property
    def language_code(self) -> str:
        """
        Gets the language_code of this OutgoingMessageRequest.
        The language used for this message. EG 'en-us' or 'es', etc; These language codes are W3C language identification tags (ISO 639-1 for the language name and ISO 3166 for the country code).

        :return: The language_code of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code: str) -> None:
        """
        Sets the language_code of this OutgoingMessageRequest.
        The language used for this message. EG 'en-us' or 'es', etc; These language codes are W3C language identification tags (ISO 639-1 for the language name and ISO 3166 for the country code).

        :param language_code: The language_code of this OutgoingMessageRequest.
        :type: str
        """
        

        self._language_code = language_code

    @property
    def reply_messages(self) -> List['ReplyMessage']:
        """
        Gets the reply_messages of this OutgoingMessageRequest.
        This is a list of messages to send back to the user, this field can be null or an empty list.

        :return: The reply_messages of this OutgoingMessageRequest.
        :rtype: list[ReplyMessage]
        """
        return self._reply_messages

    @reply_messages.setter
    def reply_messages(self, reply_messages: List['ReplyMessage']) -> None:
        """
        Sets the reply_messages of this OutgoingMessageRequest.
        This is a list of messages to send back to the user, this field can be null or an empty list.

        :param reply_messages: The reply_messages of this OutgoingMessageRequest.
        :type: list[ReplyMessage]
        """
        

        self._reply_messages = reply_messages

    @property
    def intent(self) -> str:
        """
        Gets the intent of this OutgoingMessageRequest.
        The name of the intent the bot is either processing or has processed, this will be blank if no intent could be detected.

        :return: The intent of this OutgoingMessageRequest.
        :rtype: str
        """
        return self._intent

    @intent.setter
    def intent(self, intent: str) -> None:
        """
        Sets the intent of this OutgoingMessageRequest.
        The name of the intent the bot is either processing or has processed, this will be blank if no intent could be detected.

        :param intent: The intent of this OutgoingMessageRequest.
        :type: str
        """
        

        self._intent = intent

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this OutgoingMessageRequest.
        A value between 0 and 1.0 denoting the confidence of the discovered intent (if found) this is optional and if left null genesys assumes a confidence of 1.0 on success and 0 on fail.

        :return: The confidence of this OutgoingMessageRequest.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this OutgoingMessageRequest.
        A value between 0 and 1.0 denoting the confidence of the discovered intent (if found) this is optional and if left null genesys assumes a confidence of 1.0 on success and 0 on fail.

        :param confidence: The confidence of this OutgoingMessageRequest.
        :type: float
        """
        

        self._confidence = confidence

    @property
    def error_info(self) -> 'ErrorInfo':
        """
        Gets the error_info of this OutgoingMessageRequest.
        If the botState is Failed the bot can add this error object with more details about the error.

        :return: The error_info of this OutgoingMessageRequest.
        :rtype: ErrorInfo
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'ErrorInfo') -> None:
        """
        Sets the error_info of this OutgoingMessageRequest.
        If the botState is Failed the bot can add this error object with more details about the error.

        :param error_info: The error_info of this OutgoingMessageRequest.
        :type: ErrorInfo
        """
        

        self._error_info = error_info

    @property
    def parameters(self) -> Dict[str, str]:
        """
        Gets the parameters of this OutgoingMessageRequest.
        This is a map of string-string key, value pairs containing optional fields that can be passed from the bot for custom behavior, tracking, etc, which can be used by the flow.

        :return: The parameters of this OutgoingMessageRequest.
        :rtype: dict(str, str)
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters: Dict[str, str]) -> None:
        """
        Sets the parameters of this OutgoingMessageRequest.
        This is a map of string-string key, value pairs containing optional fields that can be passed from the bot for custom behavior, tracking, etc, which can be used by the flow.

        :param parameters: The parameters of this OutgoingMessageRequest.
        :type: dict(str, str)
        """
        

        self._parameters = parameters

    @property
    def entities(self) -> List['BotEntityValue']:
        """
        Gets the entities of this OutgoingMessageRequest.
        A set of entity values that go along with the intent.

        :return: The entities of this OutgoingMessageRequest.
        :rtype: list[BotEntityValue]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['BotEntityValue']) -> None:
        """
        Sets the entities of this OutgoingMessageRequest.
        A set of entity values that go along with the intent.

        :param entities: The entities of this OutgoingMessageRequest.
        :type: list[BotEntityValue]
        """
        

        self._entities = entities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

