# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PatchContentOfferStyleProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PatchContentOfferStyleProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'padding': 'str',
            'color': 'str',
            'background_color': 'str'
        }

        self.attribute_map = {
            'padding': 'padding',
            'color': 'color',
            'background_color': 'backgroundColor'
        }

        self._padding = None
        self._color = None
        self._background_color = None

    @property
    def padding(self) -> str:
        """
        Gets the padding of this PatchContentOfferStyleProperties.
        Padding of the offer. (eg. 10px)

        :return: The padding of this PatchContentOfferStyleProperties.
        :rtype: str
        """
        return self._padding

    @padding.setter
    def padding(self, padding: str) -> None:
        """
        Sets the padding of this PatchContentOfferStyleProperties.
        Padding of the offer. (eg. 10px)

        :param padding: The padding of this PatchContentOfferStyleProperties.
        :type: str
        """
        

        self._padding = padding

    @property
    def color(self) -> str:
        """
        Gets the color of this PatchContentOfferStyleProperties.
        Text color of the offer. (eg. #FF0000)

        :return: The color of this PatchContentOfferStyleProperties.
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color: str) -> None:
        """
        Sets the color of this PatchContentOfferStyleProperties.
        Text color of the offer. (eg. #FF0000)

        :param color: The color of this PatchContentOfferStyleProperties.
        :type: str
        """
        

        self._color = color

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this PatchContentOfferStyleProperties.
        Background color of the offer. (eg. #000000)

        :return: The background_color of this PatchContentOfferStyleProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this PatchContentOfferStyleProperties.
        Background color of the offer. (eg. #000000)

        :param background_color: The background_color of this PatchContentOfferStyleProperties.
        :type: str
        """
        

        self._background_color = background_color

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

