# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PaymentLineItem

class PaymentRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PaymentRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'payment_platform': 'str',
            'country_code': 'str',
            'currency_code': 'str',
            'order_total': 'float',
            'line_items': 'list[PaymentLineItem]',
            'shipping_options': 'list[PaymentLineItem]'
        }

        self.attribute_map = {
            'payment_platform': 'paymentPlatform',
            'country_code': 'countryCode',
            'currency_code': 'currencyCode',
            'order_total': 'orderTotal',
            'line_items': 'lineItems',
            'shipping_options': 'shippingOptions'
        }

        self._payment_platform = None
        self._country_code = None
        self._currency_code = None
        self._order_total = None
        self._line_items = None
        self._shipping_options = None

    @property
    def payment_platform(self) -> str:
        """
        Gets the payment_platform of this PaymentRequest.
        The payment platform being used (e.g. Apple Pay)

        :return: The payment_platform of this PaymentRequest.
        :rtype: str
        """
        return self._payment_platform

    @payment_platform.setter
    def payment_platform(self, payment_platform: str) -> None:
        """
        Sets the payment_platform of this PaymentRequest.
        The payment platform being used (e.g. Apple Pay)

        :param payment_platform: The payment_platform of this PaymentRequest.
        :type: str
        """
        if isinstance(payment_platform, int):
            payment_platform = str(payment_platform)
        allowed_values = ["ApplePay"]
        if payment_platform.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for payment_platform -> " + payment_platform)
            self._payment_platform = "outdated_sdk_version"
        else:
            self._payment_platform = payment_platform

    @property
    def country_code(self) -> str:
        """
        Gets the country_code of this PaymentRequest.
        The merchant's two-letter ISO 3166 country code.

        :return: The country_code of this PaymentRequest.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code: str) -> None:
        """
        Sets the country_code of this PaymentRequest.
        The merchant's two-letter ISO 3166 country code.

        :param country_code: The country_code of this PaymentRequest.
        :type: str
        """
        

        self._country_code = country_code

    @property
    def currency_code(self) -> str:
        """
        Gets the currency_code of this PaymentRequest.
        The three-letter ISO 4217 currency code for the payment.

        :return: The currency_code of this PaymentRequest.
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code: str) -> None:
        """
        Sets the currency_code of this PaymentRequest.
        The three-letter ISO 4217 currency code for the payment.

        :param currency_code: The currency_code of this PaymentRequest.
        :type: str
        """
        

        self._currency_code = currency_code

    @property
    def order_total(self) -> float:
        """
        Gets the order_total of this PaymentRequest.
        The total price of the order.

        :return: The order_total of this PaymentRequest.
        :rtype: float
        """
        return self._order_total

    @order_total.setter
    def order_total(self, order_total: float) -> None:
        """
        Sets the order_total of this PaymentRequest.
        The total price of the order.

        :param order_total: The order_total of this PaymentRequest.
        :type: float
        """
        

        self._order_total = order_total

    @property
    def line_items(self) -> List['PaymentLineItem']:
        """
        Gets the line_items of this PaymentRequest.
        The items that make up the order.

        :return: The line_items of this PaymentRequest.
        :rtype: list[PaymentLineItem]
        """
        return self._line_items

    @line_items.setter
    def line_items(self, line_items: List['PaymentLineItem']) -> None:
        """
        Sets the line_items of this PaymentRequest.
        The items that make up the order.

        :param line_items: The line_items of this PaymentRequest.
        :type: list[PaymentLineItem]
        """
        

        self._line_items = line_items

    @property
    def shipping_options(self) -> List['PaymentLineItem']:
        """
        Gets the shipping_options of this PaymentRequest.
        The available shipping options.

        :return: The shipping_options of this PaymentRequest.
        :rtype: list[PaymentLineItem]
        """
        return self._shipping_options

    @shipping_options.setter
    def shipping_options(self, shipping_options: List['PaymentLineItem']) -> None:
        """
        Sets the shipping_options of this PaymentRequest.
        The available shipping options.

        :param shipping_options: The shipping_options of this PaymentRequest.
        :type: list[PaymentLineItem]
        """
        

        self._shipping_options = shipping_options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

