# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PaymentResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PaymentResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'originating_message_id': 'str',
            'payment_status': 'str',
            'failure_reason': 'str'
        }

        self.attribute_map = {
            'originating_message_id': 'originatingMessageId',
            'payment_status': 'paymentStatus',
            'failure_reason': 'failureReason'
        }

        self._originating_message_id = None
        self._payment_status = None
        self._failure_reason = None

    @property
    def originating_message_id(self) -> str:
        """
        Gets the originating_message_id of this PaymentResponse.
        Reference to the ID of the original payment request message this response is for.

        :return: The originating_message_id of this PaymentResponse.
        :rtype: str
        """
        return self._originating_message_id

    @originating_message_id.setter
    def originating_message_id(self, originating_message_id: str) -> None:
        """
        Sets the originating_message_id of this PaymentResponse.
        Reference to the ID of the original payment request message this response is for.

        :param originating_message_id: The originating_message_id of this PaymentResponse.
        :type: str
        """
        

        self._originating_message_id = originating_message_id

    @property
    def payment_status(self) -> str:
        """
        Gets the payment_status of this PaymentResponse.
        The status of the payment transaction.

        :return: The payment_status of this PaymentResponse.
        :rtype: str
        """
        return self._payment_status

    @payment_status.setter
    def payment_status(self, payment_status: str) -> None:
        """
        Sets the payment_status of this PaymentResponse.
        The status of the payment transaction.

        :param payment_status: The payment_status of this PaymentResponse.
        :type: str
        """
        if isinstance(payment_status, int):
            payment_status = str(payment_status)
        allowed_values = ["Completed", "Failed"]
        if payment_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for payment_status -> " + payment_status)
            self._payment_status = "outdated_sdk_version"
        else:
            self._payment_status = payment_status

    @property
    def failure_reason(self) -> str:
        """
        Gets the failure_reason of this PaymentResponse.
        The reason the payment request failed.

        :return: The failure_reason of this PaymentResponse.
        :rtype: str
        """
        return self._failure_reason

    @failure_reason.setter
    def failure_reason(self, failure_reason: str) -> None:
        """
        Sets the failure_reason of this PaymentResponse.
        The reason the payment request failed.

        :param failure_reason: The failure_reason of this PaymentResponse.
        :type: str
        """
        

        self._failure_reason = failure_reason

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

