# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PlanningGroupOutputs

class PerformancePredictionOutputs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PerformancePredictionOutputs - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'calculation_start_date': 'datetime',
            'calculation_interval_length_minutes': 'int',
            'planning_group_results': 'list[PlanningGroupOutputs]'
        }

        self.attribute_map = {
            'calculation_start_date': 'calculationStartDate',
            'calculation_interval_length_minutes': 'calculationIntervalLengthMinutes',
            'planning_group_results': 'planningGroupResults'
        }

        self._calculation_start_date = None
        self._calculation_interval_length_minutes = None
        self._planning_group_results = None

    @property
    def calculation_start_date(self) -> datetime:
        """
        Gets the calculation_start_date of this PerformancePredictionOutputs.
        Date as an ISO-8601 string, corresponding to the beginning of the performance prediction results

        :return: The calculation_start_date of this PerformancePredictionOutputs.
        :rtype: datetime
        """
        return self._calculation_start_date

    @calculation_start_date.setter
    def calculation_start_date(self, calculation_start_date: datetime) -> None:
        """
        Sets the calculation_start_date of this PerformancePredictionOutputs.
        Date as an ISO-8601 string, corresponding to the beginning of the performance prediction results

        :param calculation_start_date: The calculation_start_date of this PerformancePredictionOutputs.
        :type: datetime
        """
        

        self._calculation_start_date = calculation_start_date

    @property
    def calculation_interval_length_minutes(self) -> int:
        """
        Gets the calculation_interval_length_minutes of this PerformancePredictionOutputs.
        Interval length of the response metrics

        :return: The calculation_interval_length_minutes of this PerformancePredictionOutputs.
        :rtype: int
        """
        return self._calculation_interval_length_minutes

    @calculation_interval_length_minutes.setter
    def calculation_interval_length_minutes(self, calculation_interval_length_minutes: int) -> None:
        """
        Sets the calculation_interval_length_minutes of this PerformancePredictionOutputs.
        Interval length of the response metrics

        :param calculation_interval_length_minutes: The calculation_interval_length_minutes of this PerformancePredictionOutputs.
        :type: int
        """
        

        self._calculation_interval_length_minutes = calculation_interval_length_minutes

    @property
    def planning_group_results(self) -> List['PlanningGroupOutputs']:
        """
        Gets the planning_group_results of this PerformancePredictionOutputs.
        List of planning group level performance prediction results

        :return: The planning_group_results of this PerformancePredictionOutputs.
        :rtype: list[PlanningGroupOutputs]
        """
        return self._planning_group_results

    @planning_group_results.setter
    def planning_group_results(self, planning_group_results: List['PlanningGroupOutputs']) -> None:
        """
        Sets the planning_group_results of this PerformancePredictionOutputs.
        List of planning group level performance prediction results

        :param planning_group_results: The planning_group_results of this PerformancePredictionOutputs.
        :type: list[PlanningGroupOutputs]
        """
        

        self._planning_group_results = planning_group_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

