# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PersistentConnectionChangeTopicErrorInfoDetails

class PersistentConnectionChangeTopicErrorInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PersistentConnectionChangeTopicErrorInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'text': 'str',
            'code': 'str',
            'user_message': 'str',
            'user_params': 'dict(str, str)',
            'nested_error_details': 'list[PersistentConnectionChangeTopicErrorInfoDetails]'
        }

        self.attribute_map = {
            'text': 'text',
            'code': 'code',
            'user_message': 'userMessage',
            'user_params': 'userParams',
            'nested_error_details': 'nestedErrorDetails'
        }

        self._text = None
        self._code = None
        self._user_message = None
        self._user_params = None
        self._nested_error_details = None

    @property
    def text(self) -> str:
        """
        Gets the text of this PersistentConnectionChangeTopicErrorInfo.


        :return: The text of this PersistentConnectionChangeTopicErrorInfo.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this PersistentConnectionChangeTopicErrorInfo.


        :param text: The text of this PersistentConnectionChangeTopicErrorInfo.
        :type: str
        """
        

        self._text = text

    @property
    def code(self) -> str:
        """
        Gets the code of this PersistentConnectionChangeTopicErrorInfo.


        :return: The code of this PersistentConnectionChangeTopicErrorInfo.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code: str) -> None:
        """
        Sets the code of this PersistentConnectionChangeTopicErrorInfo.


        :param code: The code of this PersistentConnectionChangeTopicErrorInfo.
        :type: str
        """
        

        self._code = code

    @property
    def user_message(self) -> str:
        """
        Gets the user_message of this PersistentConnectionChangeTopicErrorInfo.


        :return: The user_message of this PersistentConnectionChangeTopicErrorInfo.
        :rtype: str
        """
        return self._user_message

    @user_message.setter
    def user_message(self, user_message: str) -> None:
        """
        Sets the user_message of this PersistentConnectionChangeTopicErrorInfo.


        :param user_message: The user_message of this PersistentConnectionChangeTopicErrorInfo.
        :type: str
        """
        

        self._user_message = user_message

    @property
    def user_params(self) -> Dict[str, str]:
        """
        Gets the user_params of this PersistentConnectionChangeTopicErrorInfo.


        :return: The user_params of this PersistentConnectionChangeTopicErrorInfo.
        :rtype: dict(str, str)
        """
        return self._user_params

    @user_params.setter
    def user_params(self, user_params: Dict[str, str]) -> None:
        """
        Sets the user_params of this PersistentConnectionChangeTopicErrorInfo.


        :param user_params: The user_params of this PersistentConnectionChangeTopicErrorInfo.
        :type: dict(str, str)
        """
        

        self._user_params = user_params

    @property
    def nested_error_details(self) -> List['PersistentConnectionChangeTopicErrorInfoDetails']:
        """
        Gets the nested_error_details of this PersistentConnectionChangeTopicErrorInfo.


        :return: The nested_error_details of this PersistentConnectionChangeTopicErrorInfo.
        :rtype: list[PersistentConnectionChangeTopicErrorInfoDetails]
        """
        return self._nested_error_details

    @nested_error_details.setter
    def nested_error_details(self, nested_error_details: List['PersistentConnectionChangeTopicErrorInfoDetails']) -> None:
        """
        Sets the nested_error_details of this PersistentConnectionChangeTopicErrorInfo.


        :param nested_error_details: The nested_error_details of this PersistentConnectionChangeTopicErrorInfo.
        :type: list[PersistentConnectionChangeTopicErrorInfoDetails]
        """
        

        self._nested_error_details = nested_error_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

