# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PlanningPeriodShiftConstraints(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PlanningPeriodShiftConstraints - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'minimum_count': 'int',
            'maximum_count': 'int'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'minimum_count': 'minimumCount',
            'maximum_count': 'maximumCount'
        }

        self._enabled = None
        self._minimum_count = None
        self._maximum_count = None

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this PlanningPeriodShiftConstraints.
        Whether shifts per planning period is enabled. This field is non-nullable on the response

        :return: The enabled of this PlanningPeriodShiftConstraints.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this PlanningPeriodShiftConstraints.
        Whether shifts per planning period is enabled. This field is non-nullable on the response

        :param enabled: The enabled of this PlanningPeriodShiftConstraints.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def minimum_count(self) -> int:
        """
        Gets the minimum_count of this PlanningPeriodShiftConstraints.
        The minimum number of shifts required per planning period. This field is non-nullable on the response

        :return: The minimum_count of this PlanningPeriodShiftConstraints.
        :rtype: int
        """
        return self._minimum_count

    @minimum_count.setter
    def minimum_count(self, minimum_count: int) -> None:
        """
        Sets the minimum_count of this PlanningPeriodShiftConstraints.
        The minimum number of shifts required per planning period. This field is non-nullable on the response

        :param minimum_count: The minimum_count of this PlanningPeriodShiftConstraints.
        :type: int
        """
        

        self._minimum_count = minimum_count

    @property
    def maximum_count(self) -> int:
        """
        Gets the maximum_count of this PlanningPeriodShiftConstraints.
        The maximum number of shifts allowed per planning period. This field is non-nullable on the response

        :return: The maximum_count of this PlanningPeriodShiftConstraints.
        :rtype: int
        """
        return self._maximum_count

    @maximum_count.setter
    def maximum_count(self, maximum_count: int) -> None:
        """
        Sets the maximum_count of this PlanningPeriodShiftConstraints.
        The maximum number of shifts allowed per planning period. This field is non-nullable on the response

        :param maximum_count: The maximum_count of this PlanningPeriodShiftConstraints.
        :type: int
        """
        

        self._maximum_count = maximum_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

