# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PolicyConditionResult

class PolicyTestResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PolicyTestResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'result': 'str',
            'policy_condition_results': 'list[PolicyConditionResult]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'result': 'result',
            'policy_condition_results': 'policyConditionResults'
        }

        self._id = None
        self._name = None
        self._result = None
        self._policy_condition_results = None

    @property
    def id(self) -> str:
        """
        Gets the id of this PolicyTestResult.
        The ID of the policy being tested.

        :return: The id of this PolicyTestResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this PolicyTestResult.
        The ID of the policy being tested.

        :param id: The id of this PolicyTestResult.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this PolicyTestResult.
        The name of the policy being tested.

        :return: The name of this PolicyTestResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this PolicyTestResult.
        The name of the policy being tested.

        :param name: The name of this PolicyTestResult.
        :type: str
        """
        

        self._name = name

    @property
    def result(self) -> str:
        """
        Gets the result of this PolicyTestResult.
        The result of the evaluation against supplied test data.

        :return: The result of this PolicyTestResult.
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result: str) -> None:
        """
        Sets the result of this PolicyTestResult.
        The result of the evaluation against supplied test data.

        :param result: The result of this PolicyTestResult.
        :type: str
        """
        

        self._result = result

    @property
    def policy_condition_results(self) -> List['PolicyConditionResult']:
        """
        Gets the policy_condition_results of this PolicyTestResult.
        The results of conditions, with their boolean result.

        :return: The policy_condition_results of this PolicyTestResult.
        :rtype: list[PolicyConditionResult]
        """
        return self._policy_condition_results

    @policy_condition_results.setter
    def policy_condition_results(self, policy_condition_results: List['PolicyConditionResult']) -> None:
        """
        Sets the policy_condition_results of this PolicyTestResult.
        The results of conditions, with their boolean result.

        :param policy_condition_results: The policy_condition_results of this PolicyTestResult.
        :type: list[PolicyConditionResult]
        """
        

        self._policy_condition_results = policy_condition_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

