# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PredictiveRouting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PredictiveRouting - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'respect_skills': 'bool',
            'enable_conversation_score_biasing': 'bool'
        }

        self.attribute_map = {
            'respect_skills': 'respectSkills',
            'enable_conversation_score_biasing': 'enableConversationScoreBiasing'
        }

        self._respect_skills = None
        self._enable_conversation_score_biasing = None

    @property
    def respect_skills(self) -> bool:
        """
        Gets the respect_skills of this PredictiveRouting.
        A switch used to determine if agent skills will be considered.

        :return: The respect_skills of this PredictiveRouting.
        :rtype: bool
        """
        return self._respect_skills

    @respect_skills.setter
    def respect_skills(self, respect_skills: bool) -> None:
        """
        Sets the respect_skills of this PredictiveRouting.
        A switch used to determine if agent skills will be considered.

        :param respect_skills: The respect_skills of this PredictiveRouting.
        :type: bool
        """
        

        self._respect_skills = respect_skills

    @property
    def enable_conversation_score_biasing(self) -> bool:
        """
        Gets the enable_conversation_score_biasing of this PredictiveRouting.
        A switch used to determine if conversations are weighted by conversation score when the system attempts to assign an agent a new conversation.

        :return: The enable_conversation_score_biasing of this PredictiveRouting.
        :rtype: bool
        """
        return self._enable_conversation_score_biasing

    @enable_conversation_score_biasing.setter
    def enable_conversation_score_biasing(self, enable_conversation_score_biasing: bool) -> None:
        """
        Sets the enable_conversation_score_biasing of this PredictiveRouting.
        A switch used to determine if conversations are weighted by conversation score when the system attempts to assign an agent a new conversation.

        :param enable_conversation_score_biasing: The enable_conversation_score_biasing of this PredictiveRouting.
        :type: bool
        """
        

        self._enable_conversation_score_biasing = enable_conversation_score_biasing

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

