# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PresentedKnowledgeDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PresentedKnowledgeDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document_id': 'str',
            'document_variation_id': 'str',
            'document_version_id': 'str',
            'surfacing_method': 'str'
        }

        self.attribute_map = {
            'document_id': 'documentId',
            'document_variation_id': 'documentVariationId',
            'document_version_id': 'documentVersionId',
            'surfacing_method': 'surfacingMethod'
        }

        self._document_id = None
        self._document_variation_id = None
        self._document_version_id = None
        self._surfacing_method = None

    @property
    def document_id(self) -> str:
        """
        Gets the document_id of this PresentedKnowledgeDocument.
        The ID of the document.

        :return: The document_id of this PresentedKnowledgeDocument.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id: str) -> None:
        """
        Sets the document_id of this PresentedKnowledgeDocument.
        The ID of the document.

        :param document_id: The document_id of this PresentedKnowledgeDocument.
        :type: str
        """
        

        self._document_id = document_id

    @property
    def document_variation_id(self) -> str:
        """
        Gets the document_variation_id of this PresentedKnowledgeDocument.
        The variation of the document.

        :return: The document_variation_id of this PresentedKnowledgeDocument.
        :rtype: str
        """
        return self._document_variation_id

    @document_variation_id.setter
    def document_variation_id(self, document_variation_id: str) -> None:
        """
        Sets the document_variation_id of this PresentedKnowledgeDocument.
        The variation of the document.

        :param document_variation_id: The document_variation_id of this PresentedKnowledgeDocument.
        :type: str
        """
        

        self._document_variation_id = document_variation_id

    @property
    def document_version_id(self) -> str:
        """
        Gets the document_version_id of this PresentedKnowledgeDocument.
        The version of the document.

        :return: The document_version_id of this PresentedKnowledgeDocument.
        :rtype: str
        """
        return self._document_version_id

    @document_version_id.setter
    def document_version_id(self, document_version_id: str) -> None:
        """
        Sets the document_version_id of this PresentedKnowledgeDocument.
        The version of the document.

        :param document_version_id: The document_version_id of this PresentedKnowledgeDocument.
        :type: str
        """
        

        self._document_version_id = document_version_id

    @property
    def surfacing_method(self) -> str:
        """
        Gets the surfacing_method of this PresentedKnowledgeDocument.
        The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.Generative: A generated answer in a snippet was shown.

        :return: The surfacing_method of this PresentedKnowledgeDocument.
        :rtype: str
        """
        return self._surfacing_method

    @surfacing_method.setter
    def surfacing_method(self, surfacing_method: str) -> None:
        """
        Sets the surfacing_method of this PresentedKnowledgeDocument.
        The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.Generative: A generated answer in a snippet was shown.

        :param surfacing_method: The surfacing_method of this PresentedKnowledgeDocument.
        :type: str
        """
        if isinstance(surfacing_method, int):
            surfacing_method = str(surfacing_method)
        allowed_values = ["Unknown", "Article", "Snippet", "Highlight", "Generative"]
        if surfacing_method.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for surfacing_method -> " + surfacing_method)
            self._surfacing_method = "outdated_sdk_version"
        else:
            self._surfacing_method = surfacing_method

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

