# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Items

class PropertyDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PropertyDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'description': 'str',
            'type': 'list[str]',
            'pattern': 'str',
            'format': 'str',
            'items': 'Items',
            'properties': 'dict(str, PropertyDefinition)'
        }

        self.attribute_map = {
            'title': 'title',
            'description': 'description',
            'type': 'type',
            'pattern': 'pattern',
            'format': 'format',
            'items': 'items',
            'properties': 'properties'
        }

        self._title = None
        self._description = None
        self._type = None
        self._pattern = None
        self._format = None
        self._items = None
        self._properties = None

    @property
    def title(self) -> str:
        """
        Gets the title of this PropertyDefinition.


        :return: The title of this PropertyDefinition.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this PropertyDefinition.


        :param title: The title of this PropertyDefinition.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this PropertyDefinition.


        :return: The description of this PropertyDefinition.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this PropertyDefinition.


        :param description: The description of this PropertyDefinition.
        :type: str
        """
        

        self._description = description

    @property
    def type(self) -> List[str]:
        """
        Gets the type of this PropertyDefinition.


        :return: The type of this PropertyDefinition.
        :rtype: list[str]
        """
        return self._type

    @type.setter
    def type(self, type: List[str]) -> None:
        """
        Sets the type of this PropertyDefinition.


        :param type: The type of this PropertyDefinition.
        :type: list[str]
        """
        

        self._type = type

    @property
    def pattern(self) -> str:
        """
        Gets the pattern of this PropertyDefinition.


        :return: The pattern of this PropertyDefinition.
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern: str) -> None:
        """
        Sets the pattern of this PropertyDefinition.


        :param pattern: The pattern of this PropertyDefinition.
        :type: str
        """
        

        self._pattern = pattern

    @property
    def format(self) -> str:
        """
        Gets the format of this PropertyDefinition.


        :return: The format of this PropertyDefinition.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format: str) -> None:
        """
        Sets the format of this PropertyDefinition.


        :param format: The format of this PropertyDefinition.
        :type: str
        """
        

        self._format = format

    @property
    def items(self) -> 'Items':
        """
        Gets the items of this PropertyDefinition.


        :return: The items of this PropertyDefinition.
        :rtype: Items
        """
        return self._items

    @items.setter
    def items(self, items: 'Items') -> None:
        """
        Sets the items of this PropertyDefinition.


        :param items: The items of this PropertyDefinition.
        :type: Items
        """
        

        self._items = items

    @property
    def properties(self) -> Dict[str, 'PropertyDefinition']:
        """
        Gets the properties of this PropertyDefinition.


        :return: The properties of this PropertyDefinition.
        :rtype: dict(str, PropertyDefinition)
        """
        return self._properties

    @properties.setter
    def properties(self, properties: Dict[str, 'PropertyDefinition']) -> None:
        """
        Sets the properties of this PropertyDefinition.


        :param properties: The properties of this PropertyDefinition.
        :type: dict(str, PropertyDefinition)
        """
        

        self._properties = properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

