# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PublishProgramTestPhraseDetectedPhrase(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PublishProgramTestPhraseDetectedPhrase - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'found_phrase': 'str',
            'snippet': 'str',
            'confidence': 'int'
        }

        self.attribute_map = {
            'found_phrase': 'foundPhrase',
            'snippet': 'snippet',
            'confidence': 'confidence'
        }

        self._found_phrase = None
        self._snippet = None
        self._confidence = None

    @property
    def found_phrase(self) -> str:
        """
        Gets the found_phrase of this PublishProgramTestPhraseDetectedPhrase.


        :return: The found_phrase of this PublishProgramTestPhraseDetectedPhrase.
        :rtype: str
        """
        return self._found_phrase

    @found_phrase.setter
    def found_phrase(self, found_phrase: str) -> None:
        """
        Sets the found_phrase of this PublishProgramTestPhraseDetectedPhrase.


        :param found_phrase: The found_phrase of this PublishProgramTestPhraseDetectedPhrase.
        :type: str
        """
        

        self._found_phrase = found_phrase

    @property
    def snippet(self) -> str:
        """
        Gets the snippet of this PublishProgramTestPhraseDetectedPhrase.


        :return: The snippet of this PublishProgramTestPhraseDetectedPhrase.
        :rtype: str
        """
        return self._snippet

    @snippet.setter
    def snippet(self, snippet: str) -> None:
        """
        Sets the snippet of this PublishProgramTestPhraseDetectedPhrase.


        :param snippet: The snippet of this PublishProgramTestPhraseDetectedPhrase.
        :type: str
        """
        

        self._snippet = snippet

    @property
    def confidence(self) -> int:
        """
        Gets the confidence of this PublishProgramTestPhraseDetectedPhrase.


        :return: The confidence of this PublishProgramTestPhraseDetectedPhrase.
        :rtype: int
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: int) -> None:
        """
        Sets the confidence of this PublishProgramTestPhraseDetectedPhrase.


        :param confidence: The confidence of this PublishProgramTestPhraseDetectedPhrase.
        :type: int
        """
        

        self._confidence = confidence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

