# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PunctualityEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PunctualityEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_schedule_start': 'datetime',
            'date_start': 'datetime',
            'length_minutes': 'int',
            'description': 'str',
            'activity_code_id': 'str',
            'activity_code': 'str',
            'activity_name': 'str',
            'category': 'str',
            'points': 'int',
            'delta': 'float',
            'bullseye': 'bool'
        }

        self.attribute_map = {
            'date_schedule_start': 'dateScheduleStart',
            'date_start': 'dateStart',
            'length_minutes': 'lengthMinutes',
            'description': 'description',
            'activity_code_id': 'activityCodeId',
            'activity_code': 'activityCode',
            'activity_name': 'activityName',
            'category': 'category',
            'points': 'points',
            'delta': 'delta',
            'bullseye': 'bullseye'
        }

        self._date_schedule_start = None
        self._date_start = None
        self._length_minutes = None
        self._description = None
        self._activity_code_id = None
        self._activity_code = None
        self._activity_name = None
        self._category = None
        self._points = None
        self._delta = None
        self._bullseye = None

    @property
    def date_schedule_start(self) -> datetime:
        """
        Gets the date_schedule_start of this PunctualityEvent.
        The scheduled activity start time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_schedule_start of this PunctualityEvent.
        :rtype: datetime
        """
        return self._date_schedule_start

    @date_schedule_start.setter
    def date_schedule_start(self, date_schedule_start: datetime) -> None:
        """
        Sets the date_schedule_start of this PunctualityEvent.
        The scheduled activity start time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_schedule_start: The date_schedule_start of this PunctualityEvent.
        :type: datetime
        """
        

        self._date_schedule_start = date_schedule_start

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this PunctualityEvent.
        The time the user started the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this PunctualityEvent.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this PunctualityEvent.
        The time the user started the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this PunctualityEvent.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this PunctualityEvent.
        The length of the activity in minutes

        :return: The length_minutes of this PunctualityEvent.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this PunctualityEvent.
        The length of the activity in minutes

        :param length_minutes: The length_minutes of this PunctualityEvent.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def description(self) -> str:
        """
        Gets the description of this PunctualityEvent.
        The description of the activity

        :return: The description of this PunctualityEvent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this PunctualityEvent.
        The description of the activity

        :param description: The description of this PunctualityEvent.
        :type: str
        """
        

        self._description = description

    @property
    def activity_code_id(self) -> str:
        """
        Gets the activity_code_id of this PunctualityEvent.
        The ID of the activity code associated with this activity

        :return: The activity_code_id of this PunctualityEvent.
        :rtype: str
        """
        return self._activity_code_id

    @activity_code_id.setter
    def activity_code_id(self, activity_code_id: str) -> None:
        """
        Sets the activity_code_id of this PunctualityEvent.
        The ID of the activity code associated with this activity

        :param activity_code_id: The activity_code_id of this PunctualityEvent.
        :type: str
        """
        

        self._activity_code_id = activity_code_id

    @property
    def activity_code(self) -> str:
        """
        Gets the activity_code of this PunctualityEvent.
        The activity code

        :return: The activity_code of this PunctualityEvent.
        :rtype: str
        """
        return self._activity_code

    @activity_code.setter
    def activity_code(self, activity_code: str) -> None:
        """
        Sets the activity_code of this PunctualityEvent.
        The activity code

        :param activity_code: The activity_code of this PunctualityEvent.
        :type: str
        """
        

        self._activity_code = activity_code

    @property
    def activity_name(self) -> str:
        """
        Gets the activity_name of this PunctualityEvent.
        The activity name

        :return: The activity_name of this PunctualityEvent.
        :rtype: str
        """
        return self._activity_name

    @activity_name.setter
    def activity_name(self, activity_name: str) -> None:
        """
        Sets the activity_name of this PunctualityEvent.
        The activity name

        :param activity_name: The activity_name of this PunctualityEvent.
        :type: str
        """
        

        self._activity_name = activity_name

    @property
    def category(self) -> str:
        """
        Gets the category of this PunctualityEvent.
        The category for the activity

        :return: The category of this PunctualityEvent.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category: str) -> None:
        """
        Sets the category of this PunctualityEvent.
        The category for the activity

        :param category: The category of this PunctualityEvent.
        :type: str
        """
        

        self._category = category

    @property
    def points(self) -> int:
        """
        Gets the points of this PunctualityEvent.
        The points earned for this activity

        :return: The points of this PunctualityEvent.
        :rtype: int
        """
        return self._points

    @points.setter
    def points(self, points: int) -> None:
        """
        Sets the points of this PunctualityEvent.
        The points earned for this activity

        :param points: The points of this PunctualityEvent.
        :type: int
        """
        

        self._points = points

    @property
    def delta(self) -> float:
        """
        Gets the delta of this PunctualityEvent.
        Difference between this activity and the last activity in seconds

        :return: The delta of this PunctualityEvent.
        :rtype: float
        """
        return self._delta

    @delta.setter
    def delta(self, delta: float) -> None:
        """
        Sets the delta of this PunctualityEvent.
        Difference between this activity and the last activity in seconds

        :param delta: The delta of this PunctualityEvent.
        :type: float
        """
        

        self._delta = delta

    @property
    def bullseye(self) -> bool:
        """
        Gets the bullseye of this PunctualityEvent.


        :return: The bullseye of this PunctualityEvent.
        :rtype: bool
        """
        return self._bullseye

    @bullseye.setter
    def bullseye(self, bullseye: bool) -> None:
        """
        Sets the bullseye of this PunctualityEvent.


        :param bullseye: The bullseye of this PunctualityEvent.
        :type: bool
        """
        

        self._bullseye = bullseye

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

