# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class QueryCapacityPlanStaffingGroupMetricChangeHistory(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueryCapacityPlanStaffingGroupMetricChangeHistory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'staffing_group_ids': 'list[str]',
            'query_end_date': 'datetime'
        }

        self.attribute_map = {
            'staffing_group_ids': 'staffingGroupIds',
            'query_end_date': 'queryEndDate'
        }

        self._staffing_group_ids = None
        self._query_end_date = None

    @property
    def staffing_group_ids(self) -> List[str]:
        """
        Gets the staffing_group_ids of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        The IDs of the staffing groups for which to fetch the metric change history

        :return: The staffing_group_ids of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        :rtype: list[str]
        """
        return self._staffing_group_ids

    @staffing_group_ids.setter
    def staffing_group_ids(self, staffing_group_ids: List[str]) -> None:
        """
        Sets the staffing_group_ids of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        The IDs of the staffing groups for which to fetch the metric change history

        :param staffing_group_ids: The staffing_group_ids of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        :type: list[str]
        """
        

        self._staffing_group_ids = staffing_group_ids

    @property
    def query_end_date(self) -> datetime:
        """
        Gets the query_end_date of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        Fetch the history of metric changes on or before this date, in IS0-8601 format. If not specified, sets to current date

        :return: The query_end_date of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        :rtype: datetime
        """
        return self._query_end_date

    @query_end_date.setter
    def query_end_date(self, query_end_date: datetime) -> None:
        """
        Sets the query_end_date of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        Fetch the history of metric changes on or before this date, in IS0-8601 format. If not specified, sets to current date

        :param query_end_date: The query_end_date of this QueryCapacityPlanStaffingGroupMetricChangeHistory.
        :type: datetime
        """
        

        self._query_end_date = query_end_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

