# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CriteriaCategoryInfo

class QueryCriteria(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueryCriteria - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'criteria_key': 'str',
            'criteria_groups': 'list[str]',
            'description': 'str',
            'operators': 'list[str]',
            'data_type': 'str',
            'category_info': 'CriteriaCategoryInfo'
        }

        self.attribute_map = {
            'criteria_key': 'criteriaKey',
            'criteria_groups': 'criteriaGroups',
            'description': 'description',
            'operators': 'operators',
            'data_type': 'dataType',
            'category_info': 'categoryInfo'
        }

        self._criteria_key = None
        self._criteria_groups = None
        self._description = None
        self._operators = None
        self._data_type = None
        self._category_info = None

    @property
    def criteria_key(self) -> str:
        """
        Gets the criteria_key of this QueryCriteria.
        The is the name of the criteria that can be queried.

        :return: The criteria_key of this QueryCriteria.
        :rtype: str
        """
        return self._criteria_key

    @criteria_key.setter
    def criteria_key(self, criteria_key: str) -> None:
        """
        Sets the criteria_key of this QueryCriteria.
        The is the name of the criteria that can be queried.

        :param criteria_key: The criteria_key of this QueryCriteria.
        :type: str
        """
        if isinstance(criteria_key, int):
            criteria_key = str(criteria_key)
        allowed_values = ["FlowStartDateTime", "FlowEndDateTime", "ConversationId", "WorkitemId", "FlowType", "FlowId", "FlowErrorReason", "FlowWarningReason", "FlowAlternateExecutionId", "FlowObjectExecutionId", "FlowActionId", "FlowActionType", "FlowActionOutputPathId", "FlowActionOutputPathName", "FlowActionIdOutputPathId", "FlowActionIdOutputPathName", "FlowActionTypeOutputPathId", "FlowActionTypeOutputPathName", "BotId", "BotErrorReason", "BotFlowExecutionId", "BotObjectExecutionId"]
        if criteria_key.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for criteria_key -> " + criteria_key)
            self._criteria_key = "outdated_sdk_version"
        else:
            self._criteria_key = criteria_key

    @property
    def criteria_groups(self) -> List[str]:
        """
        Gets the criteria_groups of this QueryCriteria.
        The executionData type that this criteria item can be used on.

        :return: The criteria_groups of this QueryCriteria.
        :rtype: list[str]
        """
        return self._criteria_groups

    @criteria_groups.setter
    def criteria_groups(self, criteria_groups: List[str]) -> None:
        """
        Sets the criteria_groups of this QueryCriteria.
        The executionData type that this criteria item can be used on.

        :param criteria_groups: The criteria_groups of this QueryCriteria.
        :type: list[str]
        """
        

        self._criteria_groups = criteria_groups

    @property
    def description(self) -> str:
        """
        Gets the description of this QueryCriteria.
        The is the description of the criteria.

        :return: The description of this QueryCriteria.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this QueryCriteria.
        The is the description of the criteria.

        :param description: The description of this QueryCriteria.
        :type: str
        """
        

        self._description = description

    @property
    def operators(self) -> List[str]:
        """
        Gets the operators of this QueryCriteria.
        A list of operators that can be used on this criteria.

        :return: The operators of this QueryCriteria.
        :rtype: list[str]
        """
        return self._operators

    @operators.setter
    def operators(self, operators: List[str]) -> None:
        """
        Sets the operators of this QueryCriteria.
        A list of operators that can be used on this criteria.

        :param operators: The operators of this QueryCriteria.
        :type: list[str]
        """
        

        self._operators = operators

    @property
    def data_type(self) -> str:
        """
        Gets the data_type of this QueryCriteria.
        The type of data for the criteria (string, int, etc).

        :return: The data_type of this QueryCriteria.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type: str) -> None:
        """
        Sets the data_type of this QueryCriteria.
        The type of data for the criteria (string, int, etc).

        :param data_type: The data_type of this QueryCriteria.
        :type: str
        """
        if isinstance(data_type, int):
            data_type = str(data_type)
        allowed_values = ["string", "guid", "dateTime"]
        if data_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for data_type -> " + data_type)
            self._data_type = "outdated_sdk_version"
        else:
            self._data_type = data_type

    @property
    def category_info(self) -> 'CriteriaCategoryInfo':
        """
        Gets the category_info of this QueryCriteria.
        A logical grouping and display order for this item.

        :return: The category_info of this QueryCriteria.
        :rtype: CriteriaCategoryInfo
        """
        return self._category_info

    @category_info.setter
    def category_info(self, category_info: 'CriteriaCategoryInfo') -> None:
        """
        Sets the category_info of this QueryCriteria.
        A logical grouping and display order for this item.

        :param category_info: The category_info of this QueryCriteria.
        :type: CriteriaCategoryInfo
        """
        

        self._category_info = category_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

