# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QuestionSettings

class QuestionGroupSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QuestionGroupSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'question_group_context_id': 'str',
            'question_settings': 'list[QuestionSettings]'
        }

        self.attribute_map = {
            'question_group_context_id': 'questionGroupContextId',
            'question_settings': 'questionSettings'
        }

        self._question_group_context_id = None
        self._question_settings = None

    @property
    def question_group_context_id(self) -> str:
        """
        Gets the question_group_context_id of this QuestionGroupSettings.
        The context id of the question group in the form.

        :return: The question_group_context_id of this QuestionGroupSettings.
        :rtype: str
        """
        return self._question_group_context_id

    @question_group_context_id.setter
    def question_group_context_id(self, question_group_context_id: str) -> None:
        """
        Sets the question_group_context_id of this QuestionGroupSettings.
        The context id of the question group in the form.

        :param question_group_context_id: The question_group_context_id of this QuestionGroupSettings.
        :type: str
        """
        

        self._question_group_context_id = question_group_context_id

    @property
    def question_settings(self) -> List['QuestionSettings']:
        """
        Gets the question_settings of this QuestionGroupSettings.


        :return: The question_settings of this QuestionGroupSettings.
        :rtype: list[QuestionSettings]
        """
        return self._question_settings

    @question_settings.setter
    def question_settings(self, question_settings: List['QuestionSettings']) -> None:
        """
        Sets the question_settings of this QuestionGroupSettings.


        :param question_settings: The question_settings of this QuestionGroupSettings.
        :type: list[QuestionSettings]
        """
        

        self._question_settings = question_settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

