# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueConversationSocialExpressionEventTopicAddress
    from . import QueueConversationSocialExpressionEventTopicInternalMessageDetails

class QueueConversationSocialExpressionEventTopicInternalMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationSocialExpressionEventTopicInternalMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'initial_state': 'str',
            'provider': 'str',
            'peer_id': 'str',
            'disconnect_type': 'str',
            'connected_time': 'datetime',
            'disconnected_time': 'datetime',
            'target_user_id': 'str',
            'source_user_id': 'str',
            'to_address': 'QueueConversationSocialExpressionEventTopicAddress',
            'from_address': 'QueueConversationSocialExpressionEventTopicAddress',
            'messages': 'list[QueueConversationSocialExpressionEventTopicInternalMessageDetails]'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'initial_state': 'initialState',
            'provider': 'provider',
            'peer_id': 'peerId',
            'disconnect_type': 'disconnectType',
            'connected_time': 'connectedTime',
            'disconnected_time': 'disconnectedTime',
            'target_user_id': 'targetUserId',
            'source_user_id': 'sourceUserId',
            'to_address': 'toAddress',
            'from_address': 'fromAddress',
            'messages': 'messages'
        }

        self._id = None
        self._state = None
        self._initial_state = None
        self._provider = None
        self._peer_id = None
        self._disconnect_type = None
        self._connected_time = None
        self._disconnected_time = None
        self._target_user_id = None
        self._source_user_id = None
        self._to_address = None
        self._from_address = None
        self._messages = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        A globally unique identifier for this communication.

        :return: The id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        A globally unique identifier for this communication.

        :param id: The id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        

        self._id = id

    @property
    def state(self) -> str:
        """
        Gets the state of this QueueConversationSocialExpressionEventTopicInternalMessage.


        :return: The state of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this QueueConversationSocialExpressionEventTopicInternalMessage.


        :param state: The state of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "connected", "disconnected"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initial_state(self) -> str:
        """
        Gets the initial_state of this QueueConversationSocialExpressionEventTopicInternalMessage.


        :return: The initial_state of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._initial_state

    @initial_state.setter
    def initial_state(self, initial_state: str) -> None:
        """
        Sets the initial_state of this QueueConversationSocialExpressionEventTopicInternalMessage.


        :param initial_state: The initial_state of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        if isinstance(initial_state, int):
            initial_state = str(initial_state)
        allowed_values = ["alerting", "connected", "disconnected"]
        if initial_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for initial_state -> " + initial_state)
            self._initial_state = "outdated_sdk_version"
        else:
            self._initial_state = initial_state

    @property
    def provider(self) -> str:
        """
        Gets the provider of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The source provider of the message.

        :return: The provider of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The source provider of the message.

        :param provider: The provider of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        

        self._provider = provider

    @property
    def peer_id(self) -> str:
        """
        Gets the peer_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The id of the peer communication corresponding to a matching leg for this communication.

        :return: The peer_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._peer_id

    @peer_id.setter
    def peer_id(self, peer_id: str) -> None:
        """
        Sets the peer_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The id of the peer communication corresponding to a matching leg for this communication.

        :param peer_id: The peer_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        

        self._peer_id = peer_id

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this QueueConversationSocialExpressionEventTopicInternalMessage.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :return: The disconnect_type of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this QueueConversationSocialExpressionEventTopicInternalMessage.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :param disconnect_type: The disconnect_type of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["client", "system", "peer", "transfer"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The timestamp when this communication was connected in the cloud clock.

        :return: The connected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The timestamp when this communication was connected in the cloud clock.

        :param connected_time: The connected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def disconnected_time(self) -> datetime:
        """
        Gets the disconnected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The timestamp when this communication disconnected from the conversation in the provider clock.

        :return: The disconnected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: datetime
        """
        return self._disconnected_time

    @disconnected_time.setter
    def disconnected_time(self, disconnected_time: datetime) -> None:
        """
        Sets the disconnected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The timestamp when this communication disconnected from the conversation in the provider clock.

        :param disconnected_time: The disconnected_time of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: datetime
        """
        

        self._disconnected_time = disconnected_time

    @property
    def target_user_id(self) -> str:
        """
        Gets the target_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The user ID for the participant on receiving side of the internal message conversation.

        :return: The target_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._target_user_id

    @target_user_id.setter
    def target_user_id(self, target_user_id: str) -> None:
        """
        Sets the target_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The user ID for the participant on receiving side of the internal message conversation.

        :param target_user_id: The target_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        

        self._target_user_id = target_user_id

    @property
    def source_user_id(self) -> str:
        """
        Gets the source_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The user ID for the participant on sending side of the internal message conversation.

        :return: The source_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: str
        """
        return self._source_user_id

    @source_user_id.setter
    def source_user_id(self, source_user_id: str) -> None:
        """
        Sets the source_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The user ID for the participant on sending side of the internal message conversation.

        :param source_user_id: The source_user_id of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: str
        """
        

        self._source_user_id = source_user_id

    @property
    def to_address(self) -> 'QueueConversationSocialExpressionEventTopicAddress':
        """
        Gets the to_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        Address and name data for a call endpoint.

        :return: The to_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: QueueConversationSocialExpressionEventTopicAddress
        """
        return self._to_address

    @to_address.setter
    def to_address(self, to_address: 'QueueConversationSocialExpressionEventTopicAddress') -> None:
        """
        Sets the to_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        Address and name data for a call endpoint.

        :param to_address: The to_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: QueueConversationSocialExpressionEventTopicAddress
        """
        

        self._to_address = to_address

    @property
    def from_address(self) -> 'QueueConversationSocialExpressionEventTopicAddress':
        """
        Gets the from_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        Address and name data for a call endpoint.

        :return: The from_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: QueueConversationSocialExpressionEventTopicAddress
        """
        return self._from_address

    @from_address.setter
    def from_address(self, from_address: 'QueueConversationSocialExpressionEventTopicAddress') -> None:
        """
        Sets the from_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        Address and name data for a call endpoint.

        :param from_address: The from_address of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: QueueConversationSocialExpressionEventTopicAddress
        """
        

        self._from_address = from_address

    @property
    def messages(self) -> List['QueueConversationSocialExpressionEventTopicInternalMessageDetails']:
        """
        Gets the messages of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The messages sent on this communication channel.

        :return: The messages of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :rtype: list[QueueConversationSocialExpressionEventTopicInternalMessageDetails]
        """
        return self._messages

    @messages.setter
    def messages(self, messages: List['QueueConversationSocialExpressionEventTopicInternalMessageDetails']) -> None:
        """
        Sets the messages of this QueueConversationSocialExpressionEventTopicInternalMessage.
        The messages sent on this communication channel.

        :param messages: The messages of this QueueConversationSocialExpressionEventTopicInternalMessage.
        :type: list[QueueConversationSocialExpressionEventTopicInternalMessageDetails]
        """
        

        self._messages = messages

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

