# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueUserEventTopicUserReference

class QueueUserEventTopicQueueMember(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueUserEventTopicQueueMember - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'user': 'QueueUserEventTopicUserReference',
            'queue_id': 'str',
            'joined': 'bool',
            'additional_properties': 'dict(str, object)'
        }

        self.attribute_map = {
            'id': 'id',
            'user': 'user',
            'queue_id': 'queueId',
            'joined': 'joined',
            'additional_properties': 'additionalProperties'
        }

        self._id = None
        self._user = None
        self._queue_id = None
        self._joined = None
        self._additional_properties = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueUserEventTopicQueueMember.


        :return: The id of this QueueUserEventTopicQueueMember.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueUserEventTopicQueueMember.


        :param id: The id of this QueueUserEventTopicQueueMember.
        :type: str
        """
        

        self._id = id

    @property
    def user(self) -> 'QueueUserEventTopicUserReference':
        """
        Gets the user of this QueueUserEventTopicQueueMember.


        :return: The user of this QueueUserEventTopicQueueMember.
        :rtype: QueueUserEventTopicUserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'QueueUserEventTopicUserReference') -> None:
        """
        Sets the user of this QueueUserEventTopicQueueMember.


        :param user: The user of this QueueUserEventTopicQueueMember.
        :type: QueueUserEventTopicUserReference
        """
        

        self._user = user

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this QueueUserEventTopicQueueMember.


        :return: The queue_id of this QueueUserEventTopicQueueMember.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this QueueUserEventTopicQueueMember.


        :param queue_id: The queue_id of this QueueUserEventTopicQueueMember.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def joined(self) -> bool:
        """
        Gets the joined of this QueueUserEventTopicQueueMember.


        :return: The joined of this QueueUserEventTopicQueueMember.
        :rtype: bool
        """
        return self._joined

    @joined.setter
    def joined(self, joined: bool) -> None:
        """
        Sets the joined of this QueueUserEventTopicQueueMember.


        :param joined: The joined of this QueueUserEventTopicQueueMember.
        :type: bool
        """
        

        self._joined = joined

    @property
    def additional_properties(self) -> Dict[str, object]:
        """
        Gets the additional_properties of this QueueUserEventTopicQueueMember.


        :return: The additional_properties of this QueueUserEventTopicQueueMember.
        :rtype: dict(str, object)
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: Dict[str, object]) -> None:
        """
        Sets the additional_properties of this QueueUserEventTopicQueueMember.


        :param additional_properties: The additional_properties of this QueueUserEventTopicQueueMember.
        :type: dict(str, object)
        """
        

        self._additional_properties = additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

