# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DatePicker
    from . import ListPicker
    from . import RecordingInput
    from . import RecordingWheelPicker

class RecordingFormPageComponent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingFormPageComponent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'form_component_type': 'str',
            'date_picker': 'DatePicker',
            'wheel_picker': 'RecordingWheelPicker',
            'list_picker': 'ListPicker',
            'input': 'RecordingInput'
        }

        self.attribute_map = {
            'form_component_type': 'formComponentType',
            'date_picker': 'datePicker',
            'wheel_picker': 'wheelPicker',
            'list_picker': 'listPicker',
            'input': 'input'
        }

        self._form_component_type = None
        self._date_picker = None
        self._wheel_picker = None
        self._list_picker = None
        self._input = None

    @property
    def form_component_type(self) -> str:
        """
        Gets the form_component_type of this RecordingFormPageComponent.
        Type of this form component element.

        :return: The form_component_type of this RecordingFormPageComponent.
        :rtype: str
        """
        return self._form_component_type

    @form_component_type.setter
    def form_component_type(self, form_component_type: str) -> None:
        """
        Sets the form_component_type of this RecordingFormPageComponent.
        Type of this form component element.

        :param form_component_type: The form_component_type of this RecordingFormPageComponent.
        :type: str
        """
        if isinstance(form_component_type, int):
            form_component_type = str(form_component_type)
        allowed_values = ["ListPicker", "DatePicker", "WheelPicker", "Input"]
        if form_component_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for form_component_type -> " + form_component_type)
            self._form_component_type = "outdated_sdk_version"
        else:
            self._form_component_type = form_component_type

    @property
    def date_picker(self) -> 'DatePicker':
        """
        Gets the date_picker of this RecordingFormPageComponent.
        Date Picker content.

        :return: The date_picker of this RecordingFormPageComponent.
        :rtype: DatePicker
        """
        return self._date_picker

    @date_picker.setter
    def date_picker(self, date_picker: 'DatePicker') -> None:
        """
        Sets the date_picker of this RecordingFormPageComponent.
        Date Picker content.

        :param date_picker: The date_picker of this RecordingFormPageComponent.
        :type: DatePicker
        """
        

        self._date_picker = date_picker

    @property
    def wheel_picker(self) -> 'RecordingWheelPicker':
        """
        Gets the wheel_picker of this RecordingFormPageComponent.
        Wheel Picker content.

        :return: The wheel_picker of this RecordingFormPageComponent.
        :rtype: RecordingWheelPicker
        """
        return self._wheel_picker

    @wheel_picker.setter
    def wheel_picker(self, wheel_picker: 'RecordingWheelPicker') -> None:
        """
        Sets the wheel_picker of this RecordingFormPageComponent.
        Wheel Picker content.

        :param wheel_picker: The wheel_picker of this RecordingFormPageComponent.
        :type: RecordingWheelPicker
        """
        

        self._wheel_picker = wheel_picker

    @property
    def list_picker(self) -> 'ListPicker':
        """
        Gets the list_picker of this RecordingFormPageComponent.
        List Picker content.

        :return: The list_picker of this RecordingFormPageComponent.
        :rtype: ListPicker
        """
        return self._list_picker

    @list_picker.setter
    def list_picker(self, list_picker: 'ListPicker') -> None:
        """
        Sets the list_picker of this RecordingFormPageComponent.
        List Picker content.

        :param list_picker: The list_picker of this RecordingFormPageComponent.
        :type: ListPicker
        """
        

        self._list_picker = list_picker

    @property
    def input(self) -> 'RecordingInput':
        """
        Gets the input of this RecordingFormPageComponent.
        Input content.

        :return: The input of this RecordingFormPageComponent.
        :rtype: RecordingInput
        """
        return self._input

    @input.setter
    def input(self, input: 'RecordingInput') -> None:
        """
        Sets the input of this RecordingFormPageComponent.
        Input content.

        :param input: The input of this RecordingFormPageComponent.
        :type: RecordingInput
        """
        

        self._input = input

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

