# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AsyncConversationQuery

class RecordingJobsQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingJobsQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'action_date': 'datetime',
            'action_age': 'int',
            'screen_recording_action_date': 'datetime',
            'screen_recording_action_age': 'int',
            'integration_id': 'str',
            'include_recordings_with_sensitive_data': 'bool',
            'include_screen_recordings': 'bool',
            'clear_export': 'bool',
            'conversation_query': 'AsyncConversationQuery',
            'aged_conversation_interval': 'str'
        }

        self.attribute_map = {
            'action': 'action',
            'action_date': 'actionDate',
            'action_age': 'actionAge',
            'screen_recording_action_date': 'screenRecordingActionDate',
            'screen_recording_action_age': 'screenRecordingActionAge',
            'integration_id': 'integrationId',
            'include_recordings_with_sensitive_data': 'includeRecordingsWithSensitiveData',
            'include_screen_recordings': 'includeScreenRecordings',
            'clear_export': 'clearExport',
            'conversation_query': 'conversationQuery',
            'aged_conversation_interval': 'agedConversationInterval'
        }

        self._action = None
        self._action_date = None
        self._action_age = None
        self._screen_recording_action_date = None
        self._screen_recording_action_age = None
        self._integration_id = None
        self._include_recordings_with_sensitive_data = None
        self._include_screen_recordings = None
        self._clear_export = None
        self._conversation_query = None
        self._aged_conversation_interval = None

    @property
    def action(self) -> str:
        """
        Gets the action of this RecordingJobsQuery.
        Operation to perform bulk task. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date.

        :return: The action of this RecordingJobsQuery.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this RecordingJobsQuery.
        Operation to perform bulk task. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date.

        :param action: The action of this RecordingJobsQuery.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["ARCHIVE", "DELETE", "EXPORT"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def action_date(self) -> datetime:
        """
        Gets the action_date of this RecordingJobsQuery.
        The date when the action will be performed. If screenRecordingActionDate is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The action_date of this RecordingJobsQuery.
        :rtype: datetime
        """
        return self._action_date

    @action_date.setter
    def action_date(self, action_date: datetime) -> None:
        """
        Sets the action_date of this RecordingJobsQuery.
        The date when the action will be performed. If screenRecordingActionDate is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param action_date: The action_date of this RecordingJobsQuery.
        :type: datetime
        """
        

        self._action_date = action_date

    @property
    def action_age(self) -> int:
        """
        Gets the action_age of this RecordingJobsQuery.
        The number of days after each recording's creation date when the action will be performed. If screenRecordingActionAge is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings.

        :return: The action_age of this RecordingJobsQuery.
        :rtype: int
        """
        return self._action_age

    @action_age.setter
    def action_age(self, action_age: int) -> None:
        """
        Sets the action_age of this RecordingJobsQuery.
        The number of days after each recording's creation date when the action will be performed. If screenRecordingActionAge is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings.

        :param action_age: The action_age of this RecordingJobsQuery.
        :type: int
        """
        

        self._action_age = action_age

    @property
    def screen_recording_action_date(self) -> datetime:
        """
        Gets the screen_recording_action_date of this RecordingJobsQuery.
        The date when the action will be performed for screen recordings. If this is provided then includeScreenRecordings must be true. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The screen_recording_action_date of this RecordingJobsQuery.
        :rtype: datetime
        """
        return self._screen_recording_action_date

    @screen_recording_action_date.setter
    def screen_recording_action_date(self, screen_recording_action_date: datetime) -> None:
        """
        Sets the screen_recording_action_date of this RecordingJobsQuery.
        The date when the action will be performed for screen recordings. If this is provided then includeScreenRecordings must be true. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param screen_recording_action_date: The screen_recording_action_date of this RecordingJobsQuery.
        :type: datetime
        """
        

        self._screen_recording_action_date = screen_recording_action_date

    @property
    def screen_recording_action_age(self) -> int:
        """
        Gets the screen_recording_action_age of this RecordingJobsQuery.
        The number of days after each screen recording's creation date when the action will be performed. If this is provided then includeScreenRecordings must be true.

        :return: The screen_recording_action_age of this RecordingJobsQuery.
        :rtype: int
        """
        return self._screen_recording_action_age

    @screen_recording_action_age.setter
    def screen_recording_action_age(self, screen_recording_action_age: int) -> None:
        """
        Sets the screen_recording_action_age of this RecordingJobsQuery.
        The number of days after each screen recording's creation date when the action will be performed. If this is provided then includeScreenRecordings must be true.

        :param screen_recording_action_age: The screen_recording_action_age of this RecordingJobsQuery.
        :type: int
        """
        

        self._screen_recording_action_age = screen_recording_action_age

    @property
    def integration_id(self) -> str:
        """
        Gets the integration_id of this RecordingJobsQuery.
        IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.

        :return: The integration_id of this RecordingJobsQuery.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id: str) -> None:
        """
        Sets the integration_id of this RecordingJobsQuery.
        IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.

        :param integration_id: The integration_id of this RecordingJobsQuery.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def include_recordings_with_sensitive_data(self) -> bool:
        """
        Gets the include_recordings_with_sensitive_data of this RecordingJobsQuery.
        Whether to include recordings with PCI DSS and/or PII data, default value = false 

        :return: The include_recordings_with_sensitive_data of this RecordingJobsQuery.
        :rtype: bool
        """
        return self._include_recordings_with_sensitive_data

    @include_recordings_with_sensitive_data.setter
    def include_recordings_with_sensitive_data(self, include_recordings_with_sensitive_data: bool) -> None:
        """
        Sets the include_recordings_with_sensitive_data of this RecordingJobsQuery.
        Whether to include recordings with PCI DSS and/or PII data, default value = false 

        :param include_recordings_with_sensitive_data: The include_recordings_with_sensitive_data of this RecordingJobsQuery.
        :type: bool
        """
        

        self._include_recordings_with_sensitive_data = include_recordings_with_sensitive_data

    @property
    def include_screen_recordings(self) -> bool:
        """
        Gets the include_screen_recordings of this RecordingJobsQuery.
        Whether to include Screen recordings for the action, default value = true 

        :return: The include_screen_recordings of this RecordingJobsQuery.
        :rtype: bool
        """
        return self._include_screen_recordings

    @include_screen_recordings.setter
    def include_screen_recordings(self, include_screen_recordings: bool) -> None:
        """
        Sets the include_screen_recordings of this RecordingJobsQuery.
        Whether to include Screen recordings for the action, default value = true 

        :param include_screen_recordings: The include_screen_recordings of this RecordingJobsQuery.
        :type: bool
        """
        

        self._include_screen_recordings = include_screen_recordings

    @property
    def clear_export(self) -> bool:
        """
        Gets the clear_export of this RecordingJobsQuery.
        For DELETE action, setting this to true will clear any pending exports for recordings. This field is only used for DELETE action. Default value = false

        :return: The clear_export of this RecordingJobsQuery.
        :rtype: bool
        """
        return self._clear_export

    @clear_export.setter
    def clear_export(self, clear_export: bool) -> None:
        """
        Sets the clear_export of this RecordingJobsQuery.
        For DELETE action, setting this to true will clear any pending exports for recordings. This field is only used for DELETE action. Default value = false

        :param clear_export: The clear_export of this RecordingJobsQuery.
        :type: bool
        """
        

        self._clear_export = clear_export

    @property
    def conversation_query(self) -> 'AsyncConversationQuery':
        """
        Gets the conversation_query of this RecordingJobsQuery.
        Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.  This result depends on the analytics data lake job completion. See also: https://developer.genesys.cloud/analyticsdatamanagement/analytics/jobs/conversation-details-job#data-availability.This is supported only when querying for conversations up to and including 5 years old.

        :return: The conversation_query of this RecordingJobsQuery.
        :rtype: AsyncConversationQuery
        """
        return self._conversation_query

    @conversation_query.setter
    def conversation_query(self, conversation_query: 'AsyncConversationQuery') -> None:
        """
        Sets the conversation_query of this RecordingJobsQuery.
        Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.  This result depends on the analytics data lake job completion. See also: https://developer.genesys.cloud/analyticsdatamanagement/analytics/jobs/conversation-details-job#data-availability.This is supported only when querying for conversations up to and including 5 years old.

        :param conversation_query: The conversation_query of this RecordingJobsQuery.
        :type: AsyncConversationQuery
        """
        

        self._conversation_query = conversation_query

    @property
    def aged_conversation_interval(self) -> str:
        """
        Gets the aged_conversation_interval of this RecordingJobsQuery.
        As an alternative to conversationQuery, specify the date and time range of conversations that are older than 5 years to query.Results will include all conversations that had activity during the interval. This is supported only when querying for conversations older than 5 years;conversationQuery must not be provided when this is provided. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss.Interval duration must not exceed 6 months. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The aged_conversation_interval of this RecordingJobsQuery.
        :rtype: str
        """
        return self._aged_conversation_interval

    @aged_conversation_interval.setter
    def aged_conversation_interval(self, aged_conversation_interval: str) -> None:
        """
        Sets the aged_conversation_interval of this RecordingJobsQuery.
        As an alternative to conversationQuery, specify the date and time range of conversations that are older than 5 years to query.Results will include all conversations that had activity during the interval. This is supported only when querying for conversations older than 5 years;conversationQuery must not be provided when this is provided. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss.Interval duration must not exceed 6 months. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param aged_conversation_interval: The aged_conversation_interval of this RecordingJobsQuery.
        :type: str
        """
        

        self._aged_conversation_interval = aged_conversation_interval

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

